package com.ruoyi.system.domain.task.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
* 工单 隐患矛盾
* @TableName tk_common_yinhuan
*/
@ApiModel("工单 隐患矛盾 新增request")
@Data
public class TkCommonYinhuanAddRequest implements Serializable {
    @ApiModelProperty("id")
    private Long id;
    @NotBlank(message = "事件名称不能为空")
    @ApiModelProperty("事件名称")
    private String title;
    @NotNull(message = "事发时间不能为空")
    @ApiModelProperty("事发时间")
    private LocalDateTime happenTime;
    @NotBlank(message = "事发地点不能为空")
    @ApiModelProperty("事发地点")
    private String address;
    @ApiModelProperty("详情")
    private String description;
    @ApiModelProperty("来源部门")
    private Long depId;
    @NotBlank(message = "危险程度不能为空")
    @ApiModelProperty("危险程度")
    private String dangerFlag;
    @Valid
    @NotEmpty(message = "关联对象不能为空")
    @ApiModelProperty("关联对象")
    private List<Bind> bindList;

    @Data
    @ApiModel("关联对象 request")
    public static class Bind{
        /**
         * @see com.ruoyi.system.domain.task.enums.TkYinhunBindTypeEnum
         */
        @NotBlank(message = "关联对象类型不能为空")
        @ApiModelProperty("关联类型 1-人口 2-住宅 3-企业 4-商铺")
        private String bindType;
        @NotBlank(message = "关联对象id不能为空")
        @ApiModelProperty("关联对象id")
        private String bindId;
    }
}
