package com.ruoyi.web.controller.task;


import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.sign.Md5Utils;
import com.ruoyi.system.domain.task.TkCommonVip;
import com.ruoyi.system.domain.task.TkCommonVipExample;
import com.ruoyi.system.service.task.TkCommonVipService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.UUID;

@Api(tags = "工单 VIP")
@RestController
@RequestMapping("/api/task/vip")
public class CommonVipController {

    @Autowired
    TkCommonVipService tkCommonVipService;

    @ApiOperation("新增")
    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    public String add(@RequestBody TkCommonVip vip) {

        try {
            TkCommonVipExample tkCommonVipExample = new TkCommonVipExample();
            TkCommonVipExample.Criteria criteria = tkCommonVipExample.createCriteria();
            criteria.andPhoneEqualTo(vip.getPhone());
            List<TkCommonVip> tkCommonVips = tkCommonVipService.selectByExample(tkCommonVipExample);
            if (tkCommonVips.size() > 0) {
                return JSON.toJSONString(AjaxResult.error(400, "当前手机号已注册"));
            }

            vip.setId(UUID.randomUUID().toString());
            vip.setPassword(Md5Utils.hash(vip.getPassword()));
            tkCommonVipService.insert(vip);
            return JSON.toJSONString(AjaxResult.success("success", vip.getId()));
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(500, "保存出错"));
        }
    }

    @ApiOperation("登录")
    @RequestMapping(value = "login", method = RequestMethod.POST)
    @ResponseBody
    public String login(@RequestBody TkCommonVip vip) {

        try {
            TkCommonVipExample tkCommonVipExample = new TkCommonVipExample();
            TkCommonVipExample.Criteria criteria = tkCommonVipExample.createCriteria();
            criteria.andPhoneEqualTo(vip.getPhone());
            List<TkCommonVip> tkCommonVips = tkCommonVipService.selectByExample(tkCommonVipExample);
            if (tkCommonVips.size() == 0) {
                return JSON.toJSONString(AjaxResult.error(500, "当前手机号未注册"));
            }

            TkCommonVip tkCommonVip = tkCommonVips.get(0);
            if (Md5Utils.hash(vip.getPassword()).equals(tkCommonVip.getPassword())) {
                return JSON.toJSONString(AjaxResult.error("success", tkCommonVip.getId()));
            } else {
                return JSON.toJSONString(AjaxResult.error(500, "账号或密码不正确"));
            }


        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(500, "保存出错"));
        }


    }

}
