package com.ruoyi.system.domain.task.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
* 工单 隐患矛盾
* @TableName tk_common_yinhuan
*/
@ApiModel("工单 隐患矛盾 查询request")
@Data
public class TkCommonYinhuanQueryRequest implements Serializable {
    @ApiModelProperty("事件名称")
    private String title;
    @ApiModelProperty("危险程度")
    private String dangerFlag;
    private Long pageNum = 1L;
    private Long pageSize = 10L;
    /**
     * @see com.ruoyi.system.domain.task.enums.TkYinhunBindTypeEnum
     */
    @ApiModelProperty("关联类型 1-人口 2-住宅 3-企业 4-商铺")
    private String bindType;

    @ApiModelProperty("关联id")
    private String bindId;
}
