package com.ruoyi.quartz.task;

import com.ruoyi.system.domain.grid.GridWorkReport;
import com.ruoyi.system.domain.grid.GridWorkReportExample;
import com.ruoyi.system.service.grid.GridWorkReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 定时任务调度测试
 *
 * @author ruoyi
 */
@Component("gridWorkReportTask")
@Slf4j
public class GridWorkReportTask {

    @Autowired
    private GridWorkReportService gridWorkReportService;

    /**
     * 创建工作简报
     */
    public void createGridWorkReport() {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Date date = new Date();

        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.MONTH, -1);

        String timeString = sdf.format(cal.getTime());

        // 年份
        String year = timeString.substring(0, 4);

        // 月份
        String month = timeString.substring(4, 6);

        log.info("生成工作简报开始:" + timeString);

        GridWorkReportExample ex = new GridWorkReportExample();
        GridWorkReportExample.Criteria ca = ex.createCriteria();
        ca.andYearEqualTo(year);
        ca.andMonthEqualTo(month);

        List<GridWorkReport> originList = gridWorkReportService.selectByExample(ex);

        if (CollectionUtils.isEmpty(originList)) {
            GridWorkReport createEvent = new GridWorkReport();
            createEvent.setYear(year);
            createEvent.setMonth(month);
            gridWorkReportService.createReport(createEvent);
            log.info("生成工作简报结束" + timeString);
        } else {
            log.info("生成工作简报结束, 数据已存在:" + timeString);
        }
    }
}
