package com.ruoyi.system.service.visit;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.zqt.ZQTreeNode;
import com.ruoyi.system.domain.visit.VisitFreePlan;
import com.ruoyi.system.domain.visit.VisitFreePlanModel;
import com.ruoyi.system.domain.visit.VisitFreePlanModelExample;
import com.ruoyi.system.domain.visit.ext.VisitFreePlanModelExt;
import com.github.pagehelper.PageInfo;
import com.ruoyi.system.service.BaseService;

/**
 * VisitFreePlanModelService接口
 * Created by cesar.X on 2022/6/21.
 */
public interface VisitFreePlanModelService extends BaseService<VisitFreePlanModel, VisitFreePlanModelExample> {

    AjaxResult addVisitFreePlanModel(VisitFreePlanModelExt visitFreePlanModel);

    AjaxResult updateVisitFreePlanModel(VisitFreePlanModelExt visitFreePlanModel);

    void delete(String id);

    VisitFreePlanModelExt info(String id);

    ZQTreeNode freePlanTree(String planModelId);

    PageInfo<VisitFreePlanModelExt> freePlanModelPage(String visitType, int pageNum, int pageSize,
                                                      Long planAllNum, String startTime, String endTime, String planType, String planTitle, String planStatus, String wgCode);

    PageInfo<VisitFreePlan> freePlanPage(SysUser sysUser,String visitType, int pageNum, int pageSize,
                                         String wgCode, String hasDone, String planTitle);
}