package com.ruoyi.system.service.operatingmanage.impl;

import cn.hutool.core.lang.Validator;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.domain.operatingmanage.WsImportantNews;
import com.ruoyi.system.domain.operatingmanage.WsImportantNewsExample;
import com.ruoyi.system.domain.operatingmanage.vo.WsImportantNewsExt;
import com.ruoyi.system.domain.publicservice.TOtherappAttachment;
import com.ruoyi.system.domain.publicservice.TOtherappAttachmentExample;
import com.ruoyi.system.domain.system.enums.AttachEnums;
import com.ruoyi.system.mapper.operatingmanage.WsImportantNewsMapper;
import com.ruoyi.system.mapper.publicservice.TOtherappAttachmentMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.operatingmanage.WsImportantNewsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
* WsImportantNewsService实现
* Created by cesar.X on 2022/7/8.
*/
@Service
public class WsImportantNewsServiceImpl extends BaseServiceImpl<WsImportantNewsMapper, WsImportantNews, WsImportantNewsExample> implements WsImportantNewsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(WsImportantNewsServiceImpl.class);

    @Autowired
    WsImportantNewsMapper wsImportantNewsMapper;

    @Autowired
    private TOtherappAttachmentMapper tOtherappAttachmentMapper;

    @Override
    @Transactional
    public void addWsImportantNews(WsImportantNewsExt wsImportantNews) {
        Validator.validateNotEmpty(wsImportantNews.getNewsName(), "要闻名称为空");

        wsImportantNewsMapper.insertSelective(wsImportantNews);

        if(!CollectionUtils.isEmpty(wsImportantNews.getOtherappAttachments())){
            for(TOtherappAttachment attachment : wsImportantNews.getOtherappAttachments()){

                attachment.setAttachType(AttachEnums.AttachType.IMPORTANT_NEWS.name());
                attachment.setBusinessId(wsImportantNews.getId().toString());
                tOtherappAttachmentMapper.insertSelective(attachment);
            }
        }
    }

    @Override
    @Transactional
    public void updateWsImportantNews(WsImportantNewsExt wsImportantNews){
        Validator.validateNotEmpty(wsImportantNews.getId(), "要闻Id为空");

        wsImportantNews.setUpdateTime(new Date());
        int result = wsImportantNewsMapper.updateByPrimaryKeySelective(wsImportantNews);

        if(!CollectionUtils.isEmpty(wsImportantNews.getOtherappAttachments())){
            TOtherappAttachmentExample attachmentExample = new TOtherappAttachmentExample();
            TOtherappAttachmentExample.Criteria criteria = attachmentExample.createCriteria();
            criteria.andAttachTypeEqualTo(AttachEnums.AttachType.IMPORTANT_NEWS.name());

            for(TOtherappAttachment attachment : wsImportantNews.getOtherappAttachments()){

                attachment.setAttachType(AttachEnums.AttachType.IMPORTANT_NEWS.name());
                attachment.setBusinessId(wsImportantNews.getId().toString());
                if(null != attachment.getAttachId()){
                    tOtherappAttachmentMapper.updateByPrimaryKeySelective(attachment);
                }else{
                    tOtherappAttachmentMapper.insertSelective(attachment);
                }
            }
        }
    }

    @Override
    public WsImportantNews getWsImportantNewsById(Long id) {

        Validator.validateNotEmpty(id, "要闻Id为空");

        WsImportantNews wsImportantNews = wsImportantNewsMapper.selectByPrimaryKey(id);

        Validator.validateNotEmpty(wsImportantNews, "要闻不存在");

        WsImportantNewsExt wsImportantNewsExt = new WsImportantNewsExt();
        BeanUtils.copyProperties(wsImportantNews,wsImportantNewsExt);
        TOtherappAttachmentExample attachmentExample = new TOtherappAttachmentExample();
        TOtherappAttachmentExample.Criteria criteriaImportantNews = attachmentExample.createCriteria();
        criteriaImportantNews.andBusinessIdEqualTo(id.toString());
        criteriaImportantNews.andAttachTypeEqualTo(AttachEnums.AttachType.IMPORTANT_NEWS.name());
        criteriaImportantNews.andValidEqualTo(Byte.valueOf("1"));
        wsImportantNewsExt.setOtherappAttachments(tOtherappAttachmentMapper.selectByExample(attachmentExample));

        return wsImportantNewsExt;
    }

    @Override
    @Transactional(rollbackFor = RuntimeException.class)
    public void batchRemove(Long[] ids) {
        int count = 0;

        if(null == ids || ids.length <=0){
            throw new ServiceException("要闻id未传");
        }

        for (Long id : ids) {
            TOtherappAttachmentExample attachmentExample = new TOtherappAttachmentExample();
            TOtherappAttachmentExample.Criteria criteriaImportantNews = attachmentExample.createCriteria();
            criteriaImportantNews.andBusinessIdEqualTo(id.toString());
            criteriaImportantNews.andAttachTypeEqualTo(AttachEnums.AttachType.IMPORTANT_NEWS.name());
            criteriaImportantNews.andValidEqualTo(Byte.valueOf("1"));
            tOtherappAttachmentMapper.deleteByExample(attachmentExample);

            wsImportantNewsMapper.deleteByPrimaryKey(id);
        }
    }

    @Override
    public PageInfo<WsImportantNews> ListWsImportantNews(WsImportantNewsExt wsImportantNews){
        PageHelper.startPage(wsImportantNews.getPageNum(), wsImportantNews.getPageSize());

        WsImportantNewsExample ImportantNewsExample = new WsImportantNewsExample();
        WsImportantNewsExample.Criteria criteria = ImportantNewsExample.createCriteria();

        if(null != wsImportantNews.getValid()){
            criteria.andValidEqualTo(wsImportantNews.getValid());
        }

        if(!StringUtils.isEmpty(wsImportantNews.getNewsName())){
            criteria.andNewsNameLike("%"+wsImportantNews.getNewsName()+"%");
        }

        ImportantNewsExample.setOrderByClause(" id desc");

        List<WsImportantNews> wsImportantNewsList = wsImportantNewsMapper.selectByExample(ImportantNewsExample);
        return new PageInfo<>(wsImportantNewsList);
    }

}