package com.ruoyi.system.domain.operatingmanage;

import com.ruoyi.system.domain.publicservice.PublicServiceBaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * 通知公告
 * @author wujm<wujm@eazytec.com>
 */
public class TOperatingmanageNotice extends PublicServiceBaseEntity {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * 通知ID
	 */
	@NotNull(message = "通知ID")
	private Long noticeId;
	
	/**
	 * 公告标题
	 */
	@NotBlank(message = "通知公告标题不能为空")
	private String noticeTitle;
	
	/**
	 * 公告来源
	 */
	@NotBlank(message = "通知公告来源不能为空")
	private String noticeSource;
	
	/**
	 * 是否置顶 1置顶 0 不置顶
	 */
	@NotNull(message = "通知公告置顶方式不能为空")
	private Integer noticeTop;
	
	/**
	 * 公告内容
	 */
	@NotBlank(message = "通知公告内容不能为空")
	private String noticeContent;

	/**
	 * 发布人网格
	 */
	private String createCode;

	/**
	 * 查询范围noticeQueryRange
	 */
	private String noticeQueryRange;


	/**
	 * 通知范围
	 */
	private List<TOperatingmanageNoticeRange> noticeRange;


	public TOperatingmanageNotice() {
		super();
	}

    /**
     * setter for noticeId
     * @param noticeId
     */
	public void setNoticeId(Long noticeId) {
		this.noticeId = noticeId;
	}

    /**
     * getter for noticeId
     */
	public Long getNoticeId() {
		return noticeId;
	}
	
    /**
     * setter for noticeTitle
     * @param noticeTitle
     */
	public void setNoticeTitle(String noticeTitle) {
		this.noticeTitle = noticeTitle;
	}

    /**
     * getter for noticeTitle
     */
	public String getNoticeTitle() {
		return noticeTitle;
	}
	
    /**
     * setter for noticeSource
     * @param noticeSource
     */
	public void setNoticeSource(String noticeSource) {
		this.noticeSource = noticeSource;
	}

    /**
     * getter for noticeSource
     */
	public String getNoticeSource() {
		return noticeSource;
	}
	
    /**
     * setter for noticeTop
     * @param noticeTop
     */
	public void setNoticeTop(Integer noticeTop) {
		this.noticeTop = noticeTop;
	}

    /**
     * getter for noticeTop
     */
	public Integer getNoticeTop() {
		return noticeTop;
	}
	
    /**
     * setter for noticeContent
     * @param noticeContent
     */
	public void setNoticeContent(String noticeContent) {
		this.noticeContent = noticeContent;
	}

    /**
     * getter for noticeContent
     */
	public String getNoticeContent() {
		return noticeContent;
	}

	public List<TOperatingmanageNoticeRange> getNoticeRange() {
		return noticeRange;
	}

	public void setNoticeRange(List<TOperatingmanageNoticeRange> noticeRange) {
		this.noticeRange = noticeRange;
	}

	public String getCreateCode() {
		return createCode;
	}

	public void setCreateCode(String createCode) {
		this.createCode = createCode;
	}

	public String getNoticeQueryRange() {
		return noticeQueryRange;
	}

	public void setNoticeQueryRange(String noticeQueryRange) {
		this.noticeQueryRange = noticeQueryRange;
	}
}
