package com.ruoyi.system.domain.grid.enums;

public enum GridCompanyEcoInfoEnum {

    SALE_TYPE("sale", "企业销售"),

    TAX_TYPE("tax", "企业税收"),

    PER_MY_TYPE("perMu", "亩均税收"),

    SHARE_AREA_TYPE("shareArea", "占地面积");

    private String code;

    private String value;

    private GridCompanyEcoInfoEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static GridCompanyEcoInfoEnum getByCode(String code) {
        if (code == null || code.trim().length() <= 0) {
            return null;
        }
        for (int i = 0; i < values().length; i++) {
            if (values()[i].code.equals(code)) {
                return values()[i];
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
