package com.ruoyi.system.domain.form.enums;

import java.util.HashMap;
import java.util.Map;

public enum EnumFormPublishStatus {
    collecting(1,"收集中"),
    toPublish(0,"未发布"),
    finish(2,"已结束"),
    ;

    public int code;
    public String text;

    EnumFormPublishStatus(int code, String text) {
        this.code = code;
        this.text = text;
    }

    public static Map<Integer, EnumFormPublishStatus> maps = null;

    static
    {
        maps = new HashMap<>();
        for(EnumFormPublishStatus it : EnumFormPublishStatus.values())
        {
            maps.put(it.getCode(),it);
        }
    }

    public static EnumFormPublishStatus getByCode(int code)
    {
        return maps.get(code);
    }

    public int getCode() {
        return code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

}
