package com.ruoyi.system.service.publicservice.impl;
import com.ruoyi.system.domain.publicservice.TOtherappAttachment;
import com.ruoyi.system.domain.publicservice.TOtherappAttachmentExample;
import com.ruoyi.system.mapper.publicservice.TOtherappAttachmentMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.publicservice.TOtherappAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
* TOtherappAttachmentService实现
* Created by cesar.X on 2022/5/10.
*/
@Service
@Transactional
public class TOtherappAttachmentServiceImpl extends BaseServiceImpl<TOtherappAttachmentMapper, TOtherappAttachment, TOtherappAttachmentExample> implements TOtherappAttachmentService {

    @Autowired
    TOtherappAttachmentMapper tOtherappAttachmentMapper;


    @Override
    public void deleteFiles(String businessId, String attachType) {
        TOtherappAttachmentExample example = new TOtherappAttachmentExample();
        TOtherappAttachmentExample.Criteria criteriaImportantNews = example.createCriteria();
        criteriaImportantNews.andBusinessIdEqualTo(businessId);
        criteriaImportantNews.andAttachTypeEqualTo(attachType);
        tOtherappAttachmentMapper.deleteByExample(example);
    }

    @Override
    public List<TOtherappAttachment> listByBusinessIdAndType(List<Long> busIds, String attachType) {
        TOtherappAttachmentExample example = new TOtherappAttachmentExample();
        TOtherappAttachmentExample.Criteria criteriaImportantNews = example.createCriteria();
        criteriaImportantNews.andBusinessIdIn(busIds.stream().map(String::valueOf).collect(Collectors.toList()));
        criteriaImportantNews.andAttachTypeEqualTo(attachType);
        return tOtherappAttachmentMapper.selectByExample(example);
    }
}