package com.ruoyi.system.service.operatingmanage.impl;

import com.ruoyi.common.constant.BsConstants;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.operatingmanage.TOperatingmanageNotice;
import com.ruoyi.system.domain.operatingmanage.TOperatingmanageNoticeRange;
import com.ruoyi.system.domain.system.enums.BsEnums;
import com.ruoyi.system.mapper.operatingmanage.TOperatingmanageNoticeMapper;
import com.ruoyi.system.service.grid.GridRegionService;
import com.ruoyi.system.service.grid.GridRegionUserService;
import com.ruoyi.system.service.operatingmanage.TOperatingmanageNoticeRangeService;
import com.ruoyi.system.service.operatingmanage.TOperatingmanageNoticeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 通知公告
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TOperatingmanageNoticeServiceImpl implements TOperatingmanageNoticeService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TOperatingmanageNoticeMapper tOperatingmanageNoticeMapper;

	@Autowired
	private TOperatingmanageNoticeRangeService itOperatingmanageNoticeRangeService;

	@Autowired
	private GridRegionUserService iBsWgxxUserService;

	@Autowired
	private GridRegionService iBsWgxxbService;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TOperatingmanageNotice> list(TOperatingmanageNotice tOperatingmanageNotice) {
		return tOperatingmanageNoticeMapper.list(tOperatingmanageNotice);
	}

	/**
	* 查询
	* @param id
	*/
	private TOperatingmanageNotice getObjectById(Long id) {
		return tOperatingmanageNoticeMapper.getObjectById(id);
	}

    /**
     * 分页查询
     * @param tOperatingmanageNotice
     * @return
     */
	@Override
	public List<TOperatingmanageNotice> listTOperatingmanageNotice(TOperatingmanageNotice tOperatingmanageNotice, String userId) {
		//判断小程序过来的进行校验同时复制appUserType
		if (ServletUtils.getRequest().getRequestURI().contains(BsConstants.REQUEST_SOURCE_MINIAPP)) {
//			bsBaseinfo.setAppUserType(BsEnums.ClientType.APP.getValue());
			tOperatingmanageNotice.setValid(1);
		}
		// 处理通过网格查询的通知，政府端登录显示当前网格下的通知公告
		if (StringUtils.isNotBlank(tOperatingmanageNotice.getNoticeQueryRange())) {
			List<TOperatingmanageNoticeRange> range = new ArrayList<>();
			range.add(new TOperatingmanageNoticeRange(tOperatingmanageNotice.getNoticeQueryRange()));
			//如果是3级网格则需查询并添加二级网格 群众可能会是3级网格
			String minGridCode = this.getMinGridCode(tOperatingmanageNotice.getNoticeQueryRange());
			range.add(new TOperatingmanageNoticeRange(minGridCode));
			tOperatingmanageNotice.setNoticeRange(range);
		}
		// 小程序登录将全镇的通知查询出来
//		if (BsEnums.ClientType.APP.getValue().equals(bsBaseinfo.getAppUserType())) {
//			TOperatingmanageNoticeRange noticeRange = new TOperatingmanageNoticeRange();
//			noticeRange.setGridCode("-1");
//			if (StringUtils.isNull(tOperatingmanageNotice.getNoticeRange())) {
//				tOperatingmanageNotice.setNoticeRange(new ArrayList<>());
//			}
//			tOperatingmanageNotice.getNoticeRange().add(noticeRange);
//		}
		// 政府登录加入办理人网格的条件
//		if (BsEnums.ClientType.GOV.getValue().equals(bsBaseinfo.getAppUserType())) {
			GridRegionUser bsWgxxUser = iBsWgxxUserService.selectByUserId(userId);
			if(bsWgxxUser != null){
				tOperatingmanageNotice.setCreateCode(this.getMinGridCode(bsWgxxUser.getWgId()));
			}
//		}
		List<TOperatingmanageNotice> tOperatingmanageNoticeList = this.list(tOperatingmanageNotice);
		//查询配置的网格范围
		for(TOperatingmanageNotice notice:tOperatingmanageNoticeList) {
			TOperatingmanageNoticeRange range = new TOperatingmanageNoticeRange();
			range.setNoticeId(notice.getNoticeId());
			notice.setNoticeRange(itOperatingmanageNoticeRangeService.listTOperatingmanageNoticeRange(range));
		}
		return tOperatingmanageNoticeList;
	}

    /**
     * 新增
     * @param tOperatingmanageNotice
     * @return
     */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public int saveTOperatingmanageNotice(TOperatingmanageNotice tOperatingmanageNotice, String userId) {
		// 查询发布人网格
		GridRegionUser bsWgxxUser = iBsWgxxUserService.selectByUserId(userId);
		if (StringUtils.isNull(bsWgxxUser)) {
			throw new ServiceException("未查询到网格信息");
		}
		tOperatingmanageNotice.setCreateCode(this.getMinGridCode(bsWgxxUser.getWgId()));
		int count = tOperatingmanageNoticeMapper.save(tOperatingmanageNotice);
		if (count==0) {
			throw new ServiceException("数据保存失败");
		}
		for (TOperatingmanageNoticeRange tOperatingmanageNoticeRange:tOperatingmanageNotice.getNoticeRange()) {
			tOperatingmanageNoticeRange.setNoticeId(tOperatingmanageNotice.getNoticeId());
			itOperatingmanageNoticeRangeService.saveTOperatingmanageNoticeRange(tOperatingmanageNoticeRange);
		}
		return count;
	}

	/**
	 * 获取网格的最小网格code，即村及其以下的获取到村，镇的就获取镇的
	 * @param code
	 */
	private String getMinGridCode(String code){
		GridRegion bsWgxxb = iBsWgxxbService.loadDetailByCode(code);
		if ("1".equals(bsWgxxb.getLevel()) || "2".equals(bsWgxxb.getLevel())) {
			return code;
		}
		//查询上级网格
		GridRegion bsWg = iBsWgxxbService.loadDetailByCode(bsWgxxb.getWgParentId());
		//System.out.println("bsWg--->"+bsWg);
		return getMinGridCode(bsWg.getWgCode());
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TOperatingmanageNotice getTOperatingmanageNoticeById(Long id) {
		TOperatingmanageNotice tOperatingmanageNotice = this.getObjectById(id);
		if (StringUtils.isNull(tOperatingmanageNotice)) {
			throw new ServiceException(BsConstants.ERROR_QUERY_NOT_FOUND);
		}
		TOperatingmanageNoticeRange tOperatingmanageNoticeRange = new TOperatingmanageNoticeRange();
		tOperatingmanageNoticeRange.setNoticeId(tOperatingmanageNotice.getNoticeId());
		tOperatingmanageNotice.setNoticeRange(itOperatingmanageNoticeRangeService.listTOperatingmanageNoticeRange(tOperatingmanageNoticeRange));
		return tOperatingmanageNotice;
	}

    /**
     * 修改
     * @param tOperatingmanageNotice
     * @return
     */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public int updateTOperatingmanageNotice(TOperatingmanageNotice tOperatingmanageNotice) {
		itOperatingmanageNoticeRangeService.removeByNoticeId(tOperatingmanageNotice.getNoticeId());
		for (TOperatingmanageNoticeRange tOperatingmanageNoticeRange:tOperatingmanageNotice.getNoticeRange()) {
			tOperatingmanageNoticeRange.setNoticeId(tOperatingmanageNotice.getNoticeId());
			itOperatingmanageNoticeRangeService.saveTOperatingmanageNoticeRange(tOperatingmanageNoticeRange);
		}
		return tOperatingmanageNoticeMapper.update(tOperatingmanageNotice);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			itOperatingmanageNoticeRangeService.removeByNoticeId(id);
			count += tOperatingmanageNoticeMapper.remove(id);
		}
		return count;
	}

	/**
	 * 修改通知公告基础信息
	 *
	 * @param tOperatingmanageNotice
	 * @return
	 */
	@Override
	public int basicTOperatingmanageNotice(TOperatingmanageNotice tOperatingmanageNotice) {
		return tOperatingmanageNoticeMapper.update(tOperatingmanageNotice);
	}
}
