package com.ruoyi.party.mapper;

import com.ruoyi.party.domain.PartyMember;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 党员Mapper接口
 * 
 * @author ruoyi
 * @date 2024-05-17
 */
public interface PartyMemberMapper 
{
    /**
     * 查询党员
     * 
     * @param id 党员主键
     * @return 党员
     */
    public PartyMember selectPartyMemberById(Long id);

    /**
     * 查询党员列表
     * 
     * @param partyMember 党员
     * @return 党员集合
     */
    public List<PartyMember> selectPartyMemberList(PartyMember partyMember);

    /**
     * 新增党员
     * 
     * @param partyMember 党员
     * @return 结果
     */
    public int insertPartyMember(PartyMember partyMember);

    /**
     * 修改党员
     * 
     * @param partyMember 党员
     * @return 结果
     */
    public int updatePartyMember(PartyMember partyMember);

    /**
     * 删除党员
     * 
     * @param id 党员主键
     * @return 结果
     */
    public int deletePartyMemberById(String id);

    /**
     * 批量删除党员
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePartyMemberByIds(String[] ids);


    Integer getPartyCount();

    List<Map<String, String>> getXLFB(@Param("orgId")String ordId);

    List<Map<String, String>> getDl(@Param("orgId")String ordId);

    List<String> getAgeList();
}
