package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.ext.GridGroupExt;
import com.ruoyi.system.service.grid.GridGroupLandService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : yaoqiang
 * @description: 集团与经济地块关联
 * @date : 2023-04-20 16:09
 */
@Api(tags = "网格管理 - 集团与经济地块关联")
@RestController
@RequestMapping("/api/grid/group/land")
public class GroupLandController {

    @Autowired
    private GridGroupLandService gridGroupLandService;

    @GetMapping(value = "/page")
    public AjaxResult page(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                           @RequestParam(name = "groupName", required = false) String groupName) {
        return AjaxResult.success(gridGroupLandService.page(pageNo, pageSize, groupName));
    }

    /**
     * 保存/修改
     */
    @PostMapping(value = "/saveOrUpdate")
    public AjaxResult saveOrUpdate(@RequestBody GridGroupExt wsGroupExt) {
        return gridGroupLandService.saveOrUpdate(wsGroupExt);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/detail")
    public AjaxResult detail(@RequestParam(value = "id") String id) {
        return AjaxResult.success(gridGroupLandService.detail(id));
    }

    /**
     * 删除
     */
    @GetMapping(value = "/delete")
    public AjaxResult delete(@RequestParam(value = "id") String id) {
        gridGroupLandService.delete(id);
        return AjaxResult.success("success");
    }

    /**
     * 计算集团下的地块总面积
     */
    @PostMapping(value = "/sumlandAreaTotal")
    public AjaxResult sumlandAreaTotal(@RequestBody List<String> landIds) {
        return AjaxResult.success(gridGroupLandService.sumlandAreaTotal(landIds));
    }

    /**
     * 集团下的地块关联的所有企业
     */
    @PostMapping(value = "/getRelatedCompanyList")
    public AjaxResult getRelatedCompanyList(@RequestBody List<String> landIds) {
        return AjaxResult.success(gridGroupLandService.getRelatedCompanyList(landIds));
    }

    /**
     * 集团亩均税收排名
     */
    @GetMapping(value = "bigScreen/permuSort/list")
    public AjaxResult permuSortList(@RequestParam(value = "year", required = false) String year) {
        return AjaxResult.success(gridGroupLandService.permuSortList(year));
    }

}
