package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.vo.*;
import com.ruoyi.system.service.house.HouseResourceService;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/house")
public class HouseResourceController {

    private final HouseResourceService houseResourceService;

    public HouseResourceController(HouseResourceService houseResourceService) {
        this.houseResourceService = houseResourceService;
    }

    @PostMapping
    public AjaxResult saveHouseResource(@RequestBody HouseResourceSaveUpdateDto dto) {
        houseResourceService.saveHouseResource(dto);
        return AjaxResult.success();
    }

    @GetMapping
    public AjaxResult queryHouseResourceById(@RequestParam String id) {
        return AjaxResult.success(houseResourceService.queryHouseResourceById(id));
    }

    @PutMapping
    public AjaxResult updateHouseResource(@RequestBody HouseResourceSaveUpdateDto dto) {
        houseResourceService.updateHouseResource(dto);
        return AjaxResult.success();
    }

    @DeleteMapping
    public AjaxResult deleteHouseResourceById(@RequestParam String id) {
        houseResourceService.deleteHouseResourceById(id);
        return AjaxResult.success();
    }

    @PostMapping("/batch")
    public AjaxResult batchSaveHouseResources(@RequestBody List<HouseResource> houseResources) {
        houseResourceService.batchSaveHouseResources(houseResources);
        return AjaxResult.success();
    }

    @GetMapping("/page")
    public AjaxResult getPageHouseResources(HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.pageHouseResources(query));
    }

    @GetMapping("/profileGraph")
    public AjaxResult getProfileGraphHouseResources(HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.profileGraphHouseResources(query));
    }

    @GetMapping("/app/profileGraph")
    public AjaxResult getAppProfileGraphHouseResources(HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.appProfileGraphHouseResources(query));
    }

    @GetMapping("/list")
    public AjaxResult getListHouseResources(HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.listHouseResources(query));
    }

    @GetMapping("/businessEntityStatistics")
    public AjaxResult getBusinessEntityStatistics(HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.businessEntityStatistics(query));
    }

    @PostMapping("/page/businessEntityStatistics")
    public AjaxResult getPageBusinessEntityStatistics(@RequestBody PageBusinessEntityStatisticsQuery query) {
        return AjaxResult.success(houseResourceService.pageBusinessEntityStatistics(query));
    }

    @PostMapping("/saveYearTax")
    public AjaxResult postSaveYearTax(@RequestBody YearTaxSaveUpdateDto dto) {
        houseResourceService.saveYearTax(dto);
        return AjaxResult.success();
    }

    @PostMapping("/export")
    public void export(HttpServletResponse response, HouseResourcePageQuery query) {
        List<HouseResourceExport> exportList = new ArrayList<>();
        List<HouseResourcePage> pageList = houseResourceService.listHouseResources(query);
        pageList.forEach(x -> {
            HouseResourceExport houseResourceExport = new HouseResourceExport();
            BeanUtils.copyProperties(x, houseResourceExport);
            exportList.add(houseResourceExport);
        });
        ExcelUtil<HouseResourceExport> util = new ExcelUtil<>(HouseResourceExport.class);
        util.exportExcel(response, exportList, "房源数据");
    }
}
