package com.ruoyi.web.controller.form;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.form.MdForm;
import com.ruoyi.system.domain.form.enums.EnumFormStatus;
import com.ruoyi.system.domain.form.params.FormAddTemplateBody;
import com.ruoyi.system.domain.form.params.FormCopyBody;
import com.ruoyi.system.domain.form.params.FormQuery;
import com.ruoyi.system.service.form.FormManager;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 表单
 */
@Api(tags = "在线表单 - 表单管理")
@RestController
@RequestMapping("/api/form")
public class FormController extends BaseController {

    @Autowired
    private FormManager formManager;

    @GetMapping(value = "/list")
    @ResponseBody
    public AjaxResult list(FormQuery query) {
        if (query == null) {
            return AjaxResult.build(400, "参数异常", "query参数不能为空");
        }

        try {
            query.setStatus(EnumFormStatus.normal.code);
            return AjaxResult.success(formManager.query(query));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    @GetMapping(value = "/detail")
    @ResponseBody
    public AjaxResult detail(@RequestParam(name = "id") String id) {
        if (StringUtils.isBlank(id)) {
            return AjaxResult.build(400, "参数异常", "id不能为空");
        }
        try {
            return AjaxResult.success(formManager.detail2(id));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    @PostMapping(value = "/save")
    @ResponseBody
    public AjaxResult save(@RequestBody MdForm body) {

        try {
            return AjaxResult.success(formManager.save(body));
        } catch (RuntimeException e1) {
            return AjaxResult.build(600, e1.getMessage(), e1.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    @PostMapping(value = "/deleteById")
    @ResponseBody
    public AjaxResult deleteById(@RequestBody MdForm body) {
        try {
            int count = formManager.deleteById(body);
            if (count > 0) {
                return AjaxResult.success("删除成功");
            }
            return AjaxResult.build(500, "删除失败", "删除失败");
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    @PostMapping(value = "/publish")
    @ResponseBody
    public AjaxResult publish(@RequestBody FormAddTemplateBody body) {

        try {
            formManager.publish(body);
            return AjaxResult.build(200, "发布成功", "发布成功");
        } catch (RuntimeException e1) {
            return AjaxResult.build(600, e1.getMessage(), e1.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }


    @GetMapping(value = "/readAuth")
    @ResponseBody
    public AjaxResult readAuth(@RequestParam(name = "userId") String userId, @RequestParam(name = "formId") String formId) {
        if (StringUtils.isEmpty(userId) || StringUtils.isEmpty(formId)) {
            return AjaxResult.build(400, "参数异常", "参数不能为空");
        }
        try {
            return formManager.readAuth(userId, formId);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //复制功能
     * @Date 11:16 2020/8/20
     * @Param [body]
     **/
    @PostMapping(value = "/copy")
    @ResponseBody
    public AjaxResult copy(@RequestBody FormCopyBody formCopyBody) {
        if (StringUtils.isEmpty(formCopyBody.getFormId()) ||
                StringUtils.isEmpty(formCopyBody.getName())
        ) {
            return AjaxResult.build(400, "参数异常", "参数不能为空");
        }
        try {
            int count = formManager.copyForm(formCopyBody);
            if (count > 0) {
                return AjaxResult.success("复制成功");
            }
            return AjaxResult.build(500, "服务器内部错误", "复制失败");
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //手动关闭收集
     * @Date 10:45 2020/8/21
     * @Param [id]
     **/
    @PostMapping(value = "/stopById")
    @ResponseBody
    public AjaxResult stopById(@RequestParam(name = "id") String id) {
        if (StringUtils.isBlank(id)) {
            return AjaxResult.build(400, "参数异常", "id不能为空");
        }
        try {
            return AjaxResult.success(formManager.stopById(id));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }
}

