/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.ui;

import com.taobao.text.LineReader;
import com.taobao.text.LineRenderer;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.LabelReader;
import com.taobao.text.util.Pair;

class LabelLineRenderer
extends LineRenderer {
    private final LabelElement element;

    LabelLineRenderer(LabelElement element) {
        this.element = element;
    }

    @Override
    public int getMinWidth() {
        return this.element.minWidth;
    }

    @Override
    public int getActualWidth() {
        return this.element.actualWidth;
    }

    @Override
    public int getActualHeight(int width) {
        return this.element.slicer.lines(width).length;
    }

    @Override
    public int getMinHeight(int width) {
        return this.getActualHeight(width);
    }

    @Override
    public LineReader reader(int width) {
        return this.reader(width, -1);
    }

    @Override
    public LineReader reader(int width, int height) {
        if (width == 0) {
            return null;
        }
        Pair<Integer, Integer>[] lines = this.element.slicer.lines(width);
        if (height == -1) {
            height = lines.length;
        }
        if (lines.length > height) {
            return null;
        }
        return new LabelReader(this.element, lines, width, height);
    }
}

