package com.ruoyi.system.domain.house.enums;

public class HouseEnums {

    public enum HouseResourceAttributeEnum {
        // 房源属性
        ZL(0, "租赁"),
        QT(1, "其他"),
        ZY(2, "自有");

        private final int code;
        private final String desc;

        HouseResourceAttributeEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static String getDescByCode(int code) {
            for (HouseResourceAttributeEnum value : HouseResourceAttributeEnum.values()) {
                if (value.getCode() == code) {
                    return value.getDesc();
                }
            }
            return null;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum HouseResourceTypeEnum {
        // 房源类型
        ZY(0, "在营"),
        KZ(1, "闲置"),
        GK(2, "挂靠"),
        SBC(3, "设备层");

        private final int code;
        private final String desc;

        HouseResourceTypeEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static String getDescByCode(int code) {
            for (HouseResourceTypeEnum value : HouseResourceTypeEnum.values()) {
                if (value.getCode() == code) {
                    return value.getDesc();
                }
            }
            return null;
        }
    }

    public enum DecorationConditionEnum {
        // 装修情况
        JZ(0, "精装"),
        JIANZHUAN(1, "简装"),
        MP(2, "毛胚");

        private final int code;
        private final String desc;

        DecorationConditionEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static String getDescByCode(int code) {
            for (DecorationConditionEnum value : DecorationConditionEnum.values()) {
                if (value.getCode() == code) {
                    return value.getDesc();
                }
            }
            return null;
        }
    }

    public enum OrientationEnum {
        // 朝向
        D(0, "东"),
        N(1, "南"),
        X(2, "西"),
        B(3, "北"),
        DN(4, "东南"),
        DB(5, "东北"),
        XN(6, "西南"),
        XB(7, "西北"),
        NB(8, "南北"),
        DX(9, "东西");

        private final int code;
        private final String desc;

        OrientationEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static String getDescByCode(int code) {
            for (OrientationEnum value : OrientationEnum.values()) {
                if (value.getCode() == code) {
                    return value.getDesc();
                }
            }
            return null;
        }
    }

    public enum RentalUnitEnum {
        // 租金单位
        A(0, "元/㎡*天"),
        B(1, "元/天"),
        C(2, "元/㎡*月"),
        D(3, "元/月"),
        E(4, "元/年"),
        F(5, "万元/年"),
        ;

        private final int code;
        private final String desc;

        RentalUnitEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static String getDescByCode(int code) {
            for (RentalUnitEnum value : RentalUnitEnum.values()) {
                if (value.getCode() == code) {
                    return value.getDesc();
                }
            }
            return null;
        }
    }

    public enum hireStatusTextEnum {
        // 租金单位
        KZ(0, "空置中"),
        CZ(1, "出租中"),
        SD(2, "已锁定"),
        XS(3, "销售"),
        ZY(4, "自用"),
        GB(5, "已关闭");

        private final int code;
        private final String desc;

        hireStatusTextEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        public static String getDescByCode(int code) {
            for (hireStatusTextEnum value : hireStatusTextEnum.values()) {
                if (value.getCode() == code) {
                    return value.getDesc();
                }
            }
            return null;
        }
    }
}
