package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.vo.HouseResourcePageQuery;
import com.ruoyi.system.service.house.HouseResourceService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/house")
public class HouseResourceController {

    private final HouseResourceService houseResourceService;

    public HouseResourceController(HouseResourceService houseResourceService) {
        this.houseResourceService = houseResourceService;
    }

    @PostMapping
    public void saveHouseResource(@RequestBody HouseResource houseResource) {
        houseResourceService.saveHouseResource(houseResource);
    }

    @GetMapping
    public AjaxResult queryHouseResourceById(@RequestParam String id) {
        return AjaxResult.success(houseResourceService.queryHouseResourceById(id));
    }

    @PutMapping
    public AjaxResult updateHouseResource(@RequestBody HouseResource houseResource) {
        houseResourceService.updateHouseResource(houseResource);
        return AjaxResult.success();
    }

    @DeleteMapping
    public AjaxResult deleteHouseResourceById(@RequestParam String id) {
        houseResourceService.deleteHouseResourceById(id);
        return AjaxResult.success();
    }

    @PostMapping("/batch")
    public AjaxResult batchSaveHouseResources(@RequestBody List<HouseResource> houseResources) {
        houseResourceService.batchSaveHouseResources(houseResources);
        return AjaxResult.success();
    }

    @GetMapping("/page")
    public AjaxResult pageHouseResources(HouseResourcePageQuery query) {
        return AjaxResult.success(houseResourceService.pageHouseResources(query));
    }

}
