package com.ruoyi.system.mapper.house;

import com.ruoyi.system.domain.house.BusinessEntityInfo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

public interface BusinessEntityInfoMapper {

    // 插入业务实体信息
    void insertBusinessEntityInfo(BusinessEntityInfo businessEntityInfo);

    // 根据ID查询业务实体信息
    BusinessEntityInfo selectBusinessEntityInfoById(@Param("id") String id);

    // 更新业务实体信息
    void updateBusinessEntityInfo(BusinessEntityInfo businessEntityInfo);

    // 删除业务实体信息
    void deleteBusinessEntityInfoById(@Param("id") String id);

    // 查询所有业务实体信息
    List<BusinessEntityInfo> selectAllBusinessEntityInfos();

    void deleteByHouseResourceId(@Param("houseResourceId") String houseResourceId);

    List<BusinessEntityInfo> selectAllBusinessEntityInfosByHouseResourceId(@Param("houseResourceId") String houseResourceId);

    List<BusinessEntityInfo> selectAllBusinessEntityInfosByHouseResourceIds(@Param("houseResourceIds") List<String> houseResourceIds);

    BigDecimal selectYearSellByHouseResourceId(@Param("houseResourceId") String houseResourceId);

    List<BusinessEntityInfo> selectByName(@Param("name") String name);
}
