package com.ruoyi.system.service.video.impl;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.oauth.utils.HttpUtils;
import com.ruoyi.system.domain.video.ext.*;
import com.ruoyi.system.service.video.IccInfoService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class IccInfoServiceImpl implements IccInfoService {

    private String host = "122.193.135.82";
    private String port = "8443";
    private String username = "admin";
    private String password = "Admin123";
    private String clientId = "duijie1";
    private String clientSecret = "7fe439aa-5190-4d24-97a1-89df65bfa8b6";
    private boolean isHttp = false;

    @Override
    public DevicePageResponse getDevicePage(DevicePageRequest devicePageRequest) {
        OauthConfigUserPwdInfo config = new OauthConfigUserPwdInfo(host, clientId, clientSecret, username, password, isHttp, port);
        DevicePageResponse response = null;
        try {
            response = HttpUtils.executeJson("/evo-apigw/evo-brm/1.2.0/device/subsystem/page", devicePageRequest, null, Method.POST, config, DevicePageResponse.class);
        } catch (ClientException e) {
            System.err.println(e.getMessage());
        }
        if (!response.isSuccess()) {
            return null;
        }
        return response;
    }


    //获取全部设备信息
    public DeviceTreeRoot getDeviceList() {
        DeviceTreeRoot root = DeviceTreeRoot.init();
        DevicePageRequest devicePageRequest = new DevicePageRequest();
        devicePageRequest.setPageNum(1);
        devicePageRequest.setPageSize(50);
        DevicePageResponse devicePageResponse = getDevicePage(devicePageRequest);
        if (devicePageResponse.isSuccess()) {
            if (!CollectionUtils.isEmpty(devicePageResponse.getData().getPageData())) {
                Integer totalPages = devicePageResponse.getData().getTotalPage();
                //若总页数大于0，遍历获取所有设备信息
                if (totalPages != null && totalPages > 0) {
                    for (int i = 0; i < totalPages; i++) {
                        devicePageRequest.setPageNum(i + 1);
                        devicePageResponse = getDevicePage(devicePageRequest);
                        for (int j = 0; j < devicePageResponse.getData().getPageData().size(); j++) {
                            String name = devicePageResponse.getData().getPageData().get(j).getDeviceName();
                            if("卓易机房EVS".equals(name) || "东来国际NVR".equals(name)){
                                System.out.println(2);
                            }
                            else {
                                continue;
                            }
                            String code = devicePageResponse.getData().getPageData().get(j).getDeviceCode();
                            String device = devicePageResponse.getData().getPageData().get(j).getDeviceName();
                            String ip = devicePageResponse.getData().getPageData().get(j).getDeviceIp();
                            int port = devicePageResponse.getData().getPageData().get(j).getDevicePort();

                            List<DevicePageResponse.PageVO.DeviceInfoVO.UnitVO.ChannelVO> channels = devicePageResponse.getData().getPageData().get(j).getUnits().get(0).getChannels();
                            if ("卓易机房EVS".equals(name)) {
                                root.getChildren().get(0).setName(name);
                                root.getChildren().get(0).setDeviceIp(ip);
                                root.getChildren().get(0).setDevicePort(port);
                                root.getChildren().get(0).setDeviceCode(code);
                                root.getChildren().get(0).setDeviceName(device);

                                DeviceTreeLeaf deviceTreeLeaf = new DeviceTreeLeaf();
                                for (int z = 0; z < channels.size(); z++) {
                                    DevicePageResponse.PageVO.DeviceInfoVO.UnitVO.ChannelVO channel = channels.get(z);
                                    deviceTreeLeaf.setAccess(channel.getAccess());
                                    deviceTreeLeaf.setCapability(channel.getCapability());
                                    deviceTreeLeaf.setChannelCode(channel.getChannelCode());
                                    deviceTreeLeaf.setChannelName(channel.getChannelName());
                                    deviceTreeLeaf.setChannelSn(channel.getChannelSn());
                                    deviceTreeLeaf.setChannelSeq(channel.getChannelSeq());
                                    deviceTreeLeaf.setChannelType(channel.getChannelType());

                                    root.getChildren().get(0).getChildren().add(deviceTreeLeaf);
                                }
                            } else if ("东来国际NVR".equals(name)) {
                                root.getChildren().get(1).setName(name);
                                root.getChildren().get(1).setDeviceIp(ip);
                                root.getChildren().get(1).setDevicePort(port);
                                root.getChildren().get(1).setDeviceCode(code);

                                DeviceTreeLeaf deviceTreeLeaf = new DeviceTreeLeaf();
                                for (int z = 0; z < channels.size(); z++) {
                                    DevicePageResponse.PageVO.DeviceInfoVO.UnitVO.ChannelVO channel = channels.get(z);
                                    deviceTreeLeaf.setAccess(channel.getAccess());
                                    deviceTreeLeaf.setCapability(channel.getCapability());
                                    deviceTreeLeaf.setChannelCode(channel.getChannelCode());
                                    deviceTreeLeaf.setChannelName(channel.getChannelName());
                                    deviceTreeLeaf.setChannelSn(channel.getChannelSn());
                                    deviceTreeLeaf.setChannelSeq(channel.getChannelSeq());
                                    deviceTreeLeaf.setChannelType(channel.getChannelType());

                                    root.getChildren().get(1).getChildren().add(deviceTreeLeaf);
                                }
                            }


//                        System.out.println(devicePageResponse.getData().getPageData().get(0).getDeviceName());
//                        System.out.println(devicePageResponse.getData().getPageData().get(0).getUnits().get(0).getChannels().get(0).getChannelName());
//                        System.out.println(devicePageResponse.getData().getPageData().get(0));
                        }
                    }
                }
            }
        }
        return root;
    }


    public ChannelPageResponse getChannelPage(ChannelPageRequest channelPageRequest){
        OauthConfigUserPwdInfo config = new OauthConfigUserPwdInfo(host, clientId, clientSecret, username, password, isHttp, port);
        ChannelPageResponse response=null;
        try {
            response = HttpUtils.executeJson("/evo-apigw/evo-brm/1.2.0/device/channel/subsystem/page", channelPageRequest,null, Method.POST , config, ChannelPageResponse.class);
        } catch (ClientException e) {

        }
        if(!response.isSuccess()) {
            return null;
        }
        return response;
    }
}
