package com.ruoyi.system.service.grid.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.IdUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyLandRemark;
import com.ruoyi.system.domain.grid.GridCompanyLandRemarkExample;
import com.ruoyi.system.domain.grid.ext.GridCompanyLandRemarkExt;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridCompanyLandRemarkExtMapper;
import com.ruoyi.system.mapper.grid.GridCompanyLandRemarkMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridCompanyLandRemarkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * @author yaoqiang
 * @date 2023-04-23 11:09
 * @desc GridCompanyLandRemarkService实现
 */
@Service
@MyBaseService
public class GridCompanyLandRemarkServiceImpl extends BaseServiceImpl<GridCompanyLandRemarkMapper, GridCompanyLandRemark, GridCompanyLandRemarkExample> implements GridCompanyLandRemarkService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridCompanyLandRemarkServiceImpl.class);

    @Autowired
    GridCompanyLandRemarkMapper gridCompanyLandRemarkMapper;

    @Autowired
    GridCompanyLandRemarkExtMapper gridCompanyLandRemarkExtMapper;

    @Override
    public PageInfo<GridCompanyLandRemarkExt> page(Integer pageNo, Integer pageSize) {
        PageHelper.startPage(pageNo, pageSize);
        PageInfo<GridCompanyLandRemarkExt> pageInfo = new PageInfo<>(gridCompanyLandRemarkExtMapper.getList());
        return pageInfo;
    }

    @Override
    @Transactional
    public AjaxResult saveOrUpdate(GridCompanyLandRemark remark) {
        Validator.validateNotEmpty(remark.getCompanyId(), "企业id为空");

        GridCompanyLandRemarkExample wsCompanyLandRemarkExample = new GridCompanyLandRemarkExample();
        GridCompanyLandRemarkExample.Criteria criteria = wsCompanyLandRemarkExample.createCriteria();
        criteria.andCompanyIdEqualTo(remark.getCompanyId());
        criteria.andIsValidEqualTo("1");
        List<GridCompanyLandRemark> wsCompanyLandList = gridCompanyLandRemarkMapper.selectByExample(wsCompanyLandRemarkExample);

        if (CollectionUtils.isEmpty(wsCompanyLandList)) {
            remark.setId(IdUtil.fastSimpleUUID());
            remark.setCreateTime(DateUtil.formatDateTime(new Date()));
            gridCompanyLandRemarkMapper.insertSelective(remark);
        } else {
            GridCompanyLandRemark wsCompanyLandRemark = wsCompanyLandList.get(0);
            wsCompanyLandRemark.setRemark(remark.getRemark());
            wsCompanyLandRemark.setVacantFactoryArea(remark.getVacantFactoryArea());
            wsCompanyLandRemark.setCompanyVacantArea(remark.getCompanyVacantArea());
            gridCompanyLandRemarkMapper.updateByPrimaryKeySelective(wsCompanyLandRemark);
        }
        return AjaxResult.success("success", remark.getId());
    }

    @Override
    public GridCompanyLandRemark detail(String companyId) {
        Validator.validateNotEmpty(companyId, "企业id为空");
        GridCompanyLandRemarkExample wsCompanyLandRemarkExample = new GridCompanyLandRemarkExample();
        GridCompanyLandRemarkExample.Criteria criteria = wsCompanyLandRemarkExample.createCriteria();
        criteria.andCompanyIdEqualTo(companyId);
        criteria.andIsValidEqualTo("1");
        List<GridCompanyLandRemark> wsCompanyLandList = gridCompanyLandRemarkMapper.selectByExample(wsCompanyLandRemarkExample);
        GridCompanyLandRemark wsCompanyLandRemark = new GridCompanyLandRemark();
        if (!CollectionUtils.isEmpty(wsCompanyLandList)) {
            wsCompanyLandRemark = wsCompanyLandList.get(0);
        }
        wsCompanyLandRemark.setCompanyId(companyId);
        return wsCompanyLandRemark;
    }
}
