package com.ruoyi.system.domain.form.enums;

import java.util.HashMap;
import java.util.Map;

public enum EnumFormMode {
    ww("ww","每周"),
    m("m","每月"),
    q("q","每季度"),
    ;

    public String code;
    public String text;

    EnumFormMode(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public static Map<String, EnumFormMode> maps = null;

    static
    {
        maps = new HashMap<>();
        for(EnumFormMode it : EnumFormMode.values())
        {
            maps.put(it.getCode(),it);
        }
    }

    public static EnumFormMode getByCode(String code)
    {
        return maps.get(code);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

}
