package com.ruoyi.common.utils.bean;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author condey
 * @version $$package: com.eazytec.ework.common.util, v 0.1 2024/1/11 4:13 PM condey Exp $$
 */
public class BeanCopyUtil {

    /**
     * 转换bean
     *
     * @param source
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanUtil.toBean(source, clazz, CopyOptions.create().setIgnoreError(true));
    }

    /**
     * 批量转换
     *
     * @param sourceList
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> List<T> bathToBean(Collection sourceList, Class<T> clazz) {

        List<T> arys = new ArrayList<>();
        if (!CollectionUtils.isEmpty(sourceList)) {
            for (Object source : sourceList) {
                arys.add(toBean(source, clazz));
            }
        }
        return arys;
    }
}
