package com.ruoyi.system.service.grid.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.domain.grid.*;
import com.ruoyi.system.domain.grid.ext.GridHouseExt;
import com.ruoyi.system.domain.system.SysOtherappAttachment;
import com.ruoyi.system.domain.system.SysOtherappAttachmentExample;
import com.ruoyi.system.domain.system.enums.AttachEnums;
import com.ruoyi.system.domain.visit.enums.VisitTypeEnum;
import com.ruoyi.system.domain.visit.ext.VisitFreeInterviewExt;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridHouseInterviewMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.*;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.system.SysOtherappAttachmentService;
import com.ruoyi.system.service.visit.VisitFreeInterviewService;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridHouseInterviewService实现
 */
@Service
@MyBaseService
public class GridHouseInterviewServiceImpl extends BaseServiceImpl<GridHouseInterviewMapper, GridHouseInterview, GridHouseInterviewExample> implements GridHouseInterviewService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridHouseInterviewServiceImpl.class);

    @Autowired
    GridHouseInterviewMapper gridHouseInterviewMapper;
    @Autowired
    private GridRegionService gridRegionService;
    @Autowired
    private GridHouseService gridHouseService;
    @Autowired
    private VisitFreeInterviewService visitFreeInterviewService;
    @Autowired
    private GridRegionUserService gridRegionUserService;
    @Autowired
    private SysOtherappAttachmentService sysOtherappAttachmentService;
    @Autowired
    private GridWgLogService gridWgLogService;
    @Autowired
    private ISysUserService sysUserService;

    @Override
    public List<GridHouseInterview> interviewPage(String houseId) {
        GridHouseInterviewExample ex = new GridHouseInterviewExample();
        GridHouseInterviewExample.Criteria ca = ex.createCriteria();
        ca.andHouseIdEqualTo(houseId);
        ex.setOrderByClause(" interview_time desc, create_time desc");
        List<GridHouseInterview> list = this.selectByExample(ex);
        for (GridHouseInterview wsHouseInterview : list) {
            SysOtherappAttachmentExample ex1 = new SysOtherappAttachmentExample();
            SysOtherappAttachmentExample.Criteria ca1 = ex1.createCriteria();
            ca1.andAttachTypeEqualTo(AttachEnums.AttachType.PLAN_TASK.name());
            ca1.andBusinessIdEqualTo(wsHouseInterview.getId());
            List<SysOtherappAttachment> attachmentList = sysOtherappAttachmentService.selectByExample(ex1);
            wsHouseInterview.setAttachmentList(attachmentList);
        }
        return list;
    }

    @Override
    @Transactional
    public String interviewAdd(GridHouseInterview wsHouseInterview) {
        VisitFreeInterviewExt wszfFreeInterviewExt = new VisitFreeInterviewExt();
        wsHouseInterview.setId(IdUtil.fastSimpleUUID());
        wsHouseInterview.setWgValue(gridRegionService.getWgName(wsHouseInterview.getWgCode()));
        GridRegion region = gridRegionService.getSecondWgCode(wsHouseInterview.getWgCode());
        if (region != null) {
            wsHouseInterview.setCountry(region.getWgName());
        }
        wsHouseInterview.setCreateTime(DateUtil.formatDateTime(new Date()));
        if (CollectionUtils.isNotEmpty(wsHouseInterview.getAttachmentList())) {
            for (SysOtherappAttachment at : wsHouseInterview.getAttachmentList()) {
                at.setAttachType(AttachEnums.AttachType.PLAN_TASK.name());
                at.setBusinessId(wsHouseInterview.getId());
                sysOtherappAttachmentService.insertSelective(at);
            }
            wszfFreeInterviewExt.setOtherappAttachments(wsHouseInterview.getAttachmentList());
        }
        this.insertSelective(wsHouseInterview);

        // 调用新增自由走访数据
        wszfFreeInterviewExt.setWgCode(wsHouseInterview.getWgCode());
        wszfFreeInterviewExt.setWgValue(gridRegionService.getWgName(wsHouseInterview.getWgCode()));
        GridRegionUser regionUser = gridRegionUserService.selectByUserId(wsHouseInterview.getCreateId());
        wszfFreeInterviewExt.setWgyCode(regionUser != null ? regionUser.getWgId() : "");
        wszfFreeInterviewExt.setWgyName(wsHouseInterview.getCreateName());
        wszfFreeInterviewExt.setInterviewTime(wsHouseInterview.getInterviewTime());
        wszfFreeInterviewExt.setType("3");
        wszfFreeInterviewExt.setContent(wsHouseInterview.getContent());
        wszfFreeInterviewExt.setObjId(wsHouseInterview.getHouseId());
        wszfFreeInterviewExt.setLongitude(wsHouseInterview.getLongitude());
        wszfFreeInterviewExt.setLatitude(wsHouseInterview.getLatitude());
        wszfFreeInterviewExt.setAddress(wsHouseInterview.getAddress());
        wszfFreeInterviewExt.setActualTime(wsHouseInterview.getCreateTime());

        GridHouseExt wsHouseExt = (GridHouseExt) gridHouseService.detail(wsHouseInterview.getHouseId()).get(AjaxResult.DATA_TAG);
        if (wsHouseExt != null) {
            wszfFreeInterviewExt.setObjName(wsHouseExt.getHouseName());
            wszfFreeInterviewExt.setObjType(wsHouseExt.getFwlxCode());
            wszfFreeInterviewExt.setObjTypeName(wsHouseExt.getFwlxValue());
            wszfFreeInterviewExt.setObjUserName(wsHouseExt.getPersonName());
            wszfFreeInterviewExt.setObjNumber(wsHouseExt.getHouseName());
        }
        wszfFreeInterviewExt.setVisitType(VisitTypeEnum.FREE_VISIT.getCode());
        visitFreeInterviewService.addVisitFreeInterview(wszfFreeInterviewExt);


        // 日志
        GridWgLog wsWgLog = new GridWgLog();
        wsWgLog.setCreateId(wsHouseInterview.getCreateId());
        SysUser sysUser = sysUserService.selectUserById(wsHouseInterview.getCreateId());
        wsWgLog.setCreateName(sysUser != null ? sysUser.getNickName() : "");
        wsWgLog.setCreateWgCode(wsHouseInterview.getWgCode());
        wsWgLog.setObjectName(wsHouseInterview.getHouseName());
        wsWgLog.setType("2");
        wsWgLog.setOperate("interview");
        wsWgLog.setObjectId(wsHouseInterview.getId());
        gridWgLogService.add(wsWgLog);

        return wsHouseInterview.getId();
    }

    @Override
    public GridHouseInterview detail(String id) {
        GridHouseInterview wsHouseInterview = this.selectByPrimaryKey(id);
        if (wsHouseInterview != null) {
            SysOtherappAttachmentExample ex = new SysOtherappAttachmentExample();
            SysOtherappAttachmentExample.Criteria ca = ex.createCriteria();
            ca.andBusinessIdEqualTo(id);
            ca.andAttachTypeEqualTo(AttachEnums.AttachType.PLAN_TASK.name());
            List<SysOtherappAttachment> attachmentList = sysOtherappAttachmentService.selectByExample(ex);
            wsHouseInterview.setAttachmentList(attachmentList);
            return wsHouseInterview;
        }
        return null;
    }
}
