package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyLand;
import com.ruoyi.system.domain.grid.GridCompanyLandExample;
import com.ruoyi.system.service.grid.GridCompanyLandService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : yaoqiang
 * @description: 经济地块与企业关联
 * @date : 2023-04-20 16:09
 */
@Api(tags = "网格管理 - 经济地块与企业关联")
@RestController
@RequestMapping("/api/grid/company/land")
public class CompanyLandController {

    @Autowired
    private GridCompanyLandService gridCompanyLandService;

    @GetMapping(value = "/page")
    public AjaxResult page(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                           @RequestParam(name = "companyId", required = false) String companyId,
                           @RequestParam(name = "landId", required = false) String landId,
                           @RequestParam(name = "landPurpose", required = false) String landPurpose) {

        return AjaxResult.success(gridCompanyLandService.page(pageNo, pageSize, companyId, landId, landPurpose));
    }

    /**
     * 保存/修改
     */
    @PostMapping(value = "/saveOrUpdate")
    public AjaxResult saveOrUpdate(@RequestBody GridCompanyLand wsCompanyLand) {
        return gridCompanyLandService.saveOrUpdate(wsCompanyLand);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/detail")
    public AjaxResult detail(@RequestParam(value = "id") String id) {
        return AjaxResult.success(gridCompanyLandService.detail(id));
    }

    /**
     * 删除
     */
    @GetMapping(value = "/delete")
    public AjaxResult delete(@RequestParam(value = "id") String id) {
        gridCompanyLandService.delete(id);
        return AjaxResult.success("success");
    }

    /**
     * 企业地块信息统计
     * 总的经济地块数量，对应的企业数，对应的集团数，年度销售总数，年度税收总数，年度亩均税收数
     */
    @GetMapping(value = "bigScreen/info/statistic")
    public AjaxResult infoStatistic(@RequestParam(value = "year", required = false) String year) {
        return AjaxResult.success(gridCompanyLandService.infoStatistic(year));
    }

    /**
     * 地块租赁情况统计
     */
    @GetMapping(value = "bigScreen/lease/statistic")
    public AjaxResult leaseStatistic() {
        return AjaxResult.success(gridCompanyLandService.leaseStatistic());
    }

    /**
     * 地块亩均税收排名
     */
    @GetMapping(value = "bigScreen/permuSort/list")
    public AjaxResult permuSortList(@RequestParam(value = "year", required = false) String year) {
        return AjaxResult.success(gridCompanyLandService.permuSortList(year));
    }

    /**
     * 地块下的企业个数
     * @return
     */
    @GetMapping("/companyCount")
    public AjaxResult companyCount(@RequestParam("landId")String landId){
        GridCompanyLandExample example = new GridCompanyLandExample();
        GridCompanyLandExample.Criteria criteria = example.createCriteria();
        criteria.andLandIdEqualTo(landId);
        criteria.andIsValidEqualTo("1");
        return AjaxResult.success(gridCompanyLandService.countByExample(example));
    }

}
