package com.ruoyi.system.service.house.impl;

import com.ruoyi.system.domain.grid.GridCompany;
import com.ruoyi.system.domain.grid.GridShop;
import com.ruoyi.system.domain.house.HouseResourceAssociationObject;
import com.ruoyi.system.domain.house.vo.HouseResourceAssociationObjectVo;
import com.ruoyi.system.mapper.grid.GridCompanyMapper;
import com.ruoyi.system.mapper.grid.GridShopMapper;
import com.ruoyi.system.mapper.house.HouseResourceAssociationObjectMapper;
import com.ruoyi.system.service.house.HouseResourceAssociationObjectService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
public class HouseResourceAssociationObjectServiceImpl implements HouseResourceAssociationObjectService {

    private final HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper;

    private final GridCompanyMapper gridCompanyMapper;

    private final GridShopMapper gridShopMapper;

    public HouseResourceAssociationObjectServiceImpl(HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper, GridCompanyMapper gridCompanyMapper, GridShopMapper gridShopMapper) {
        this.houseResourceAssociationObjectMapper = houseResourceAssociationObjectMapper;
        this.gridCompanyMapper = gridCompanyMapper;
        this.gridShopMapper = gridShopMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveHouseResourceAssociationObject(HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObject.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        houseResourceAssociationObjectMapper.insertHouseResourceObjectAssociation(houseResourceAssociationObject);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateHouseResourceAssociationObject(HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObjectMapper.updateHouseResourceObjectAssociation(houseResourceAssociationObject);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteHouseResourceAssociationObjectById(String id) {
        houseResourceAssociationObjectMapper.deleteHouseResourceObjectAssociationById(id);
    }

    @Override
    public HouseResourceAssociationObjectVo queryHouseResourceAssociationObjectByHouseResourceIdType(String houseResourceId, int type) {
        HouseResourceAssociationObject houseResourceAssociationObject = houseResourceAssociationObjectMapper.selectHouseResourceObjectAssociationByHouseResourceIdType(houseResourceId, type);
        if (Objects.isNull(houseResourceAssociationObject)) {
            return null;
        }
        HouseResourceAssociationObjectVo houseResourceAssociationObjectVo = new HouseResourceAssociationObjectVo();
        BeanUtils.copyProperties(houseResourceAssociationObject, houseResourceAssociationObjectVo);
        if (type == 1) {
            GridCompany gridCompany = gridCompanyMapper.selectByPrimaryKey(houseResourceAssociationObject.getBusinessId());
            houseResourceAssociationObjectVo.setGridCompany(gridCompany);
        } else if (type == 2) {
            GridShop gridShop = gridShopMapper.selectByPrimaryKey(Long.parseLong(houseResourceAssociationObject.getBusinessId()));
            houseResourceAssociationObjectVo.setGridShop(gridShop);
        }
        return houseResourceAssociationObjectVo;
    }

    @Override
    public List<HouseResourceAssociationObjectVo> queryHouseResourceAssociationObjectLog(String houseResourceId, int type) {
        List<HouseResourceAssociationObject> houseResourceAssociationObjects = houseResourceAssociationObjectMapper.selectHouseResourceObjectAssociationLog(houseResourceId, type, 2);
        if (houseResourceAssociationObjects.isEmpty()) {
            return Collections.emptyList();
        }
        List<HouseResourceAssociationObjectVo> list = new ArrayList<>();
        houseResourceAssociationObjects.forEach(x -> {
            if (x.getType() == 1) {
                HouseResourceAssociationObjectVo houseResourceAssociationObjectVo = new HouseResourceAssociationObjectVo();
                GridCompany gridCompany = gridCompanyMapper.selectByPrimaryKey(x.getBusinessId());
                houseResourceAssociationObjectVo.setGridCompany(gridCompany);
                list.add(houseResourceAssociationObjectVo);
            } else if (x.getType() == 2) {
                HouseResourceAssociationObjectVo houseResourceAssociationObjectVo = new HouseResourceAssociationObjectVo();
                GridShop gridShop = gridShopMapper.selectByPrimaryKey(Long.parseLong(x.getBusinessId()));
                houseResourceAssociationObjectVo.setGridShop(gridShop);
                list.add(houseResourceAssociationObjectVo);
            }
        });
        return list;
    }
}
