package com.ruoyi.system.service.visit;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.visit.VisitFreeInterview;
import com.ruoyi.system.domain.visit.VisitFreeInterviewExample;
import com.ruoyi.system.domain.visit.ext.VisitFreeInterviewExt;
import com.ruoyi.system.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * VisitFreeInterviewService接口
 * Created by cesar.X on 2022/6/21.
 */
public interface VisitFreeInterviewService extends BaseService<VisitFreeInterview, VisitFreeInterviewExample> {

    AjaxResult addVisitFreeInterview(VisitFreeInterviewExt visitFreeInterview);

    PageInfo<VisitFreeInterviewExt> freeInterviewPage(String visitType, int pageNum, int pageSize,
                                                      List<String> wgCodes, String startTime, String endTime, String type,
                                                      String planModelId, String wgCode);

    List<VisitFreeInterview> interviewList(String visitType, String wgCode, String startTime, String endTime);

    Map<String, Long> interviewCountStatistic(String visitType);

    Map<String, Long> freePlanInterviewStatistic(String planModelId, List<String> wgCodes, String wgCode);

    Map<String, Long> interviewStatistic(String wgCode, String visitType, String startDate, String endDate);

    Map<String, Object> freeInterviewStatistic(String visitType);
}