package com.ruoyi.system.service.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.grid.GridItemDaily;
import com.ruoyi.system.domain.grid.GridItemDailyExample;
import com.ruoyi.system.domain.grid.vo.GridLevelTreeNode;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Auther: hxc
 * @Date: 2019/2/28 0028 16:04
 * @Description: 日常事项表
 */
@Component
public class GridItemDailyFacadeService {

    @Autowired
    private GridItemDailyService gridItemDailyService;

    public void getRoles(String sxbm, String sxmc,Integer pageNum, Integer pageSize, AjaxResult result) {
        if (null == pageNum || pageNum <= 0) {
            pageNum = 1;
        }
        if (null == pageSize || pageSize <= 0) {
            pageSize = 10;
        }

        ZQTPageModel<GridItemDaily> appPageModel = new ZQTPageModel<>();
        appPageModel.setRecordCount(0);
        appPageModel.setPageCount(0);
        appPageModel.setCurPage(pageNum);
        appPageModel.setItemList(new ArrayList<>());

        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(sxmc)) {
            criteria.andSxmcLike("%" + sxmc + "%");
            if (StringUtils.isNotEmpty(sxbm)) {
                GridItemDailyExample.Criteria criteria2 = example.createCriteria();
                criteria2.andSjflLike("%" + sxbm + "%");
                example.or(criteria2);
            }
        } else {
            if (StringUtils.isNotEmpty(sxbm)) {
                criteria.andSjflEqualTo(sxbm);
            }

        }

        example.setOrderByClause(" sxbm asc ");
        int count = gridItemDailyService.countByExample(example);
        if (count <= 0) {
            result.buildSuccess("success", appPageModel);
            return;
        }

        List<GridItemDaily> roles = gridItemDailyService.selectByExampleForStartPage(example, pageNum, pageSize);
        if (null == roles || roles.isEmpty()) {
            result.buildSuccess("success", appPageModel);
            return;
        }
        appPageModel.setCurPage(pageNum);
        appPageModel.setRecordCount(count);
        appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
        appPageModel.setItemList(roles);
        result.buildSuccess("success", appPageModel);
        return;
    }

    public void getSearch(String sjfl, String sxbm, String sxmc, Integer pageNum, Integer pageSize, AjaxResult result) {
        if (null == pageNum || pageNum <= 0) {
            pageNum = 1;
        }
        if (null == pageSize || pageSize <= 0) {
            pageSize = 10;
        }

        ZQTPageModel<GridItemDaily> appPageModel = new ZQTPageModel<>();
        appPageModel.setRecordCount(0);
        appPageModel.setPageCount(0);
        appPageModel.setCurPage(pageNum);
        appPageModel.setItemList(new ArrayList<>());

        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(sxbm)) {
            criteria.andSxbmLike("%" + sxbm + "%");
        }
        if (StringUtils.isNotEmpty(sxmc)) {
            criteria.andSxmcLike("%" + sxmc + "%");
        }
        if (StringUtils.isNotEmpty(sjfl)) {
            if (!sjfl.equals("rcsx")) {
                criteria.andSjflEqualTo(sjfl);
            }
        }
        example.setOrderByClause(" sxbm asc ");
        int count = gridItemDailyService.countByExample(example);
        if (count <= 0) {
            result.buildSuccess("success", appPageModel);
            return;
        }

        List<GridItemDaily> roles = gridItemDailyService.selectByExampleForStartPage(example, pageNum, pageSize);
        if (null == roles || roles.isEmpty()) {
            result.buildSuccess("success", appPageModel);
            return;
        }
        appPageModel.setCurPage(pageNum);
        appPageModel.setRecordCount(count);
        appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
        appPageModel.setItemList(roles);
        result.buildSuccess("success", appPageModel);
        return;
    }

    public String getSxbm(String sxbm) {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(sxbm)) {
            criteria.andSjflEqualTo(sxbm);
        }
        String code = null;
        List<GridItemDaily> roles = gridItemDailyService.selectByExample(example);
        if (roles == null) {
            code = sxbm + "001";
        } else {
            int number = 0;
            Pattern p = Pattern.compile("[0-9]");
            for (int i = 0; i < roles.size(); i++) {
                Matcher m = p.matcher(roles.get(i).getSxbm());
                if (m.find()) {
                    if (Integer.valueOf(roles.get(i).getSxbm().substring(roles.get(i).getSxbm().length() - 3, roles.get(i).getSxbm().length())) > number) {
                        number = Integer.valueOf(roles.get(i).getSxbm().substring(roles.get(i).getSxbm().length() - 3, roles.get(i).getSxbm().length()));
                    }
                }
            }
            if (number < 9) {
                code = sxbm + "00" + String.valueOf(number + 1);
            } else {
                code = sxbm + "0" + String.valueOf(number + 1);
            }
        }
        return code;
    }

    public String getSxmc(String sxbm) {
        if ("".equals(sxbm)) {
            return "";
        } else {
            GridItemDailyExample example = new GridItemDailyExample();
            GridItemDailyExample.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotEmpty(sxbm)) {
                criteria.andSxbmEqualTo(sxbm);
            }
            GridItemDaily roles = gridItemDailyService.selectFirstByExample(example);
            return roles.getSxmc();
        }

    }

    public List<GridItemDaily> DelXjSxbm(String sxbm) {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(sxbm)) {
            criteria.andSjflEqualTo(sxbm);
        }
        List<GridItemDaily> roles = gridItemDailyService.selectByExample(example);
        return roles;
    }

    public GridItemDaily selectByPrimaryKey(String id) {
        GridItemDaily bsRcsxb = gridItemDailyService.selectByPrimaryKey(id);
        return bsRcsxb;
    }

    public int rcsxbAddList(String createBy) {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        criteria.andSjflIsNull();
        int count = gridItemDailyService.countByExample(example);
        if (count <= 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式
            GridItemDaily bsRcsxb = new GridItemDaily();
            bsRcsxb.setId(UUID.randomUUID().toString());
            bsRcsxb.setSxbm("rcsx");
            bsRcsxb.setSxmc("日常事项");
            bsRcsxb.setCreateTime(df.format(new Date()));
            bsRcsxb.setCreateBy(createBy);
            bsRcsxb.setIsValid("1");

            GridItemDaily bsRcsxb1 = new GridItemDaily();
            bsRcsxb1.setId(UUID.randomUUID().toString());
            bsRcsxb1.setSxbm("qy");
            bsRcsxb1.setSxmc("企业事项");
            bsRcsxb1.setSjfl("rcsx");
            bsRcsxb1.setCreateTime(df.format(new Date()));
            bsRcsxb1.setCreateBy(createBy);
            bsRcsxb1.setIsValid("1");

            GridItemDaily bsRcsxb2 = new GridItemDaily();
            bsRcsxb2.setId(UUID.randomUUID().toString());
            bsRcsxb2.setSxbm("cx");
            bsRcsxb2.setSxmc("城乡事项");
            bsRcsxb2.setSjfl("rcsx");
            bsRcsxb2.setCreateTime(df.format(new Date()));
            bsRcsxb2.setCreateBy(createBy);
            bsRcsxb2.setIsValid("1");

            GridItemDaily bsRcsxb3 = new GridItemDaily();
            bsRcsxb3.setId(UUID.randomUUID().toString());
            bsRcsxb3.setSxbm("zc");
            bsRcsxb3.setSxmc("资产事项");
            bsRcsxb3.setSjfl("rcsx");
            bsRcsxb3.setCreateTime(df.format(new Date()));
            bsRcsxb3.setCreateBy(createBy);
            bsRcsxb3.setIsValid("1");

            gridItemDailyService.insert(bsRcsxb);
            gridItemDailyService.insert(bsRcsxb1);
            gridItemDailyService.insert(bsRcsxb2);
            gridItemDailyService.insert(bsRcsxb3);
        } else {
            return 0;
        }
        return 1;
    }

    public int rcsxdr(String sxbm, String createBy, String[] drnr) {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(sxbm)) {
            criteria.andSjflEqualTo(sxbm);
        }
        int result = 0;
        example.setOrderByClause("sxbm desc");
        List<GridItemDaily> roles = gridItemDailyService.selectByExample(example);
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateNowStr = sdf.format(d);
        if (null == roles || roles.size() == 0) {
            int num = 1;
            for (int i = 0; i < drnr.length; i++) {
                String bsbm = "";
                GridItemDaily bsRcsxb = new GridItemDaily();
                String cd = drnr[i];
                if (cd.length() < 30) {
                    if (num > 9) {
                        bsbm = sxbm + "0" + String.valueOf(num);
                    } else if (num > 99) {
                        bsbm = sxbm + String.valueOf(num);
                    } else {
                        bsbm = sxbm + "00" + String.valueOf(num);
                    }
                    bsRcsxb.setSxmc(drnr[i]);
                    bsRcsxb.setSxbm(bsbm);
                    bsRcsxb.setSjfl(sxbm);
                    bsRcsxb.setCreateBy(createBy);
                    bsRcsxb.setCreateTime(dateNowStr);
                    bsRcsxb.setIsValid("1");
                    bsRcsxb.setId(UUID.randomUUID().toString());
                    result = gridItemDailyService.insert(bsRcsxb);
                    num = num + 1;
                }
            }
        } else {
            int num = Integer.valueOf(roles.get(0).getSxbm().substring(roles.get(0).getSxbm().length() - 3, roles.get(0).getSxbm().length()));
            for (int i = 0; i < drnr.length; i++) {
                String bsbm = "";
                GridItemDaily bsRcsxb = new GridItemDaily();
                String cd = drnr[i];
                if (cd.length() < 30) {
                    num = num + 1;
                    if (num > 9) {
                        bsbm = sxbm + "0" + String.valueOf(num);
                    } else if (num > 99) {
                        bsbm = sxbm + String.valueOf(num);
                    } else {
                        bsbm = sxbm + "00" + String.valueOf(num);
                    }
                    bsRcsxb.setSxmc(drnr[i]);
                    bsRcsxb.setSxbm(bsbm);
                    bsRcsxb.setSjfl(sxbm);
                    bsRcsxb.setCreateBy(createBy);
                    bsRcsxb.setCreateTime(dateNowStr);
                    bsRcsxb.setIsValid("1");
                    bsRcsxb.setId(UUID.randomUUID().toString());
                    result = gridItemDailyService.insert(bsRcsxb);
                }
            }
        }
        return result;
    }


    public List<Map<String, Object>> getTreeNode(String sxbm) {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank(sxbm)) {
            criteria.andSjflEqualTo(sxbm);
        }
        example.setOrderByClause(" create_time asc ");
        List<GridItemDaily> bsWgxxbList = gridItemDailyService.selectByExample(example);
        List<Map<String, Object>> jsTreeModels = convertFromDocTypes(bsWgxxbList);
        return jsTreeModels;
    }

    private List<Map<String, Object>> convertFromDocTypes(List<GridItemDaily> recDocTypes) {
        List<Map<String, Object>> models = new ArrayList<>();
        if (!CollectionUtils.isEmpty(recDocTypes)) {
            for (GridItemDaily docType : recDocTypes) {
                if (docType.getSjfl() == null || docType.getSjfl().equals("")) {
                    Map<String, Object> model = new HashMap<>();
                    model.put("id", docType.getSxbm());
                    model.put("key", docType.getId());
                    model.put("text", docType.getSxmc() + "(" + String.valueOf(recDocTypes.size() - 1) + ")");
                    List<Map<String, Object>> childrenDocTypes = convertFromDocTypesByParent(recDocTypes, docType.getSxbm());
                    model.put("children", childrenDocTypes);
                    models.add(model);
                }
            }
        }
        return models;
    }

    private List<Map<String, Object>> convertFromDocTypesByParent(List<GridItemDaily> recDocTypes, String parentId) {
        List<Map<String, Object>> models = new ArrayList<>();
        for (GridItemDaily recDocType : recDocTypes) {
            if (recDocType.getSjfl() != null && parentId.equals(recDocType.getSjfl())) {
                Map<String, Object> model = new HashMap<>();
                model.put("id", recDocType.getSxbm());
                model.put("key", recDocType.getId());
                GridItemDailyExample example = new GridItemDailyExample();
                GridItemDailyExample.Criteria criteria = example.createCriteria();
                criteria.andSjflLike("%" + recDocType.getSxbm() + "%");
                int count = gridItemDailyService.countByExample(example);
                if (count == 0) {
                    model.put("text", recDocType.getSxmc());
                } else {
                    model.put("text", recDocType.getSxmc() + "(" + String.valueOf(count) + ")");
                }
                List<Map<String, Object>> childrenDocTypes = convertFromDocTypesByParent(recDocTypes, recDocType.getSxbm());
                model.put("children", childrenDocTypes);
                models.add(model);
            }
        }
        return models;
    }

    public List<Map<String, Object>> getFirstItemDailyList() {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria1 = example.createCriteria();
        GridItemDailyExample.Criteria criteria2 = example.createCriteria();
        criteria1.andIsValidEqualTo("1");
        criteria2.andIsValidEqualTo("1");
        example.setOrderByClause(" sxbm asc ");
        List<GridItemDaily> bsWgxxbList = gridItemDailyService.selectByExample(example);
        List<Map<String, Object>> jsTreeModels = dwconvertFromDocTypes(bsWgxxbList, null);
        return jsTreeModels;
    }

    //对外
    public List<Map<String, Object>> getDwItemDailyList(String sxbm, AjaxResult result) {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria1 = example.createCriteria();
        GridItemDailyExample.Criteria criteria2 = example.createCriteria();
        criteria1.andIsValidEqualTo("1");
        if (StringUtils.isNotBlank(sxbm) && !sxbm.equals("rcsx")) {
            criteria1.andSjflLike("%" + sxbm + "%");
            criteria2.andSxbmEqualTo(sxbm);
            example.or(criteria2);
        }
        example.setOrderByClause(" sxbm asc ");
        List<GridItemDaily> bsWgxxbList = gridItemDailyService.selectByExample(example);
        List<Map<String, Object>> jsTreeModels = dwconvertFromDocTypes(bsWgxxbList, sxbm);
        return jsTreeModels;
    }

    private List<Map<String, Object>> dwconvertFromDocTypes(List<GridItemDaily> recDocTypes, String sxbm) {
        List<Map<String, Object>> models = new ArrayList<>();
        if (!CollectionUtils.isEmpty(recDocTypes)) {
            for (GridItemDaily docType : recDocTypes) {
                if (sxbm != null) {
                    if (docType.getSxbm().equals(sxbm)) {
                        Map<String, Object> model = new HashMap<>();
                        model.put("id", docType.getId());
                        model.put("sxbm", docType.getSxbm());
                        model.put("sxmc", docType.getSxmc());
                        model.put("sjfl", docType.getSjfl());
                        model.put("clsx", docType.getClsx() == null ? "" : docType.getClsx());
                        model.put("zyccbm", docType.getZyccbm() == null ? "" : docType.getZyccbm());
                        model.put("lhccbm", docType.getLhccbm() == null ? "" : docType.getLhccbm());
                        model.put("createTime", docType.getCreateTime());
                        model.put("createBy", docType.getCreateBy());
                        model.put("updateTime", docType.getUpdateTime() == null ? "" : docType.getUpdateTime());
                        model.put("updateBy", docType.getUpdateBy() == null ? "" : docType.getUpdateBy());
                        model.put("isValid", docType.getIsValid());
                        model.put("fgld", docType.getFgld() == null ? "" : docType.getFgld());
                        model.put("ylzd1", docType.getYlzd1() == null ? "" : docType.getYlzd1());
                        model.put("ylzd2", docType.getYlzd2() == null ? "" : docType.getYlzd2());
                        model.put("ylzd3", docType.getYlzd3() == null ? "" : docType.getYlzd3());
                        model.put("ylzd4", docType.getYlzd4() == null ? "" : docType.getYlzd4());
                        model.put("ylzd5", docType.getYlzd5() == null ? "" : docType.getYlzd5());
                        List<Map<String, Object>> childrenDocTypes = DwconvertFromDocTypesByParent(recDocTypes, docType.getSxbm());
                        model.put("children", childrenDocTypes);
                        models.add(model);
                    }
                } else {
                    if (docType.getSjfl() == null || docType.getSjfl().equals("")) {
                        Map<String, Object> model = new HashMap<>();
                        model.put("id", docType.getId());
                        model.put("sxbm", docType.getSxbm());
                        model.put("sxmc", docType.getSxmc());
                        model.put("sjfl", docType.getSjfl());
                        model.put("clsx", docType.getClsx() == null ? "" : docType.getClsx());
                        model.put("zyccbm", docType.getZyccbm() == null ? "" : docType.getZyccbm());
                        model.put("lhccbm", docType.getLhccbm() == null ? "" : docType.getLhccbm());
                        model.put("createTime", docType.getCreateTime());
                        model.put("createBy", docType.getCreateBy());
                        model.put("updateTime", docType.getUpdateTime() == null ? "" : docType.getUpdateTime());
                        model.put("updateBy", docType.getUpdateBy() == null ? "" : docType.getUpdateBy());
                        model.put("isValid", docType.getIsValid());
                        model.put("fgld", docType.getFgld() == null ? "" : docType.getFgld());
                        model.put("ylzd1", docType.getYlzd1() == null ? "" : docType.getYlzd1());
                        model.put("ylzd2", docType.getYlzd2() == null ? "" : docType.getYlzd2());
                        model.put("ylzd3", docType.getYlzd3() == null ? "" : docType.getYlzd3());
                        List<Map<String, Object>> childrenDocTypes = DwconvertFromDocTypesByParent(recDocTypes, docType.getSxbm());
                        model.put("children", childrenDocTypes);
                        models.add(model);
                    }
                }

            }
        }
        return models;
    }

    private List<Map<String, Object>> DwconvertFromDocTypesByParent(List<GridItemDaily> recDocTypes, String parentId) {
        List<Map<String, Object>> models = new ArrayList<>();
        for (GridItemDaily recDocType : recDocTypes) {
            if (recDocType.getSjfl() != null && parentId.equals(recDocType.getSjfl())) {
                Map<String, Object> model = new HashMap<>();
                model.put("id", recDocType.getId());
                model.put("sxbm", recDocType.getSxbm());
                model.put("sxmc", recDocType.getSxmc());
                model.put("sjfl", recDocType.getSjfl());
                model.put("clsx", recDocType.getClsx() == null ? "" : recDocType.getClsx());
                model.put("zyccbm", recDocType.getZyccbm() == null ? "" : recDocType.getZyccbm());
                model.put("lhccbm", recDocType.getLhccbm() == null ? "" : recDocType.getLhccbm());
                model.put("createTime", recDocType.getCreateTime());
                model.put("createBy", recDocType.getCreateBy());
                model.put("updateTime", recDocType.getUpdateTime() == null ? "" : recDocType.getUpdateTime());
                model.put("updateBy", recDocType.getUpdateBy() == null ? "" : recDocType.getUpdateBy());
                model.put("isValid", recDocType.getIsValid());
                model.put("fgld", recDocType.getFgld() == null ? "" : recDocType.getFgld());
                model.put("ylzd1", recDocType.getYlzd1() == null ? "" : recDocType.getYlzd1());
                model.put("ylzd2", recDocType.getYlzd2() == null ? "" : recDocType.getYlzd2());
                model.put("ylzd3", recDocType.getYlzd3() == null ? "" : recDocType.getYlzd3());
                model.put("ylzd4", recDocType.getYlzd4() == null ? "" : recDocType.getYlzd4());
                model.put("ylzd5", recDocType.getYlzd5() == null ? "" : recDocType.getYlzd5());
                List<Map<String, Object>> childrenDocTypes = DwconvertFromDocTypesByParent(recDocTypes, recDocType.getSxbm());
                model.put("children", childrenDocTypes);
                models.add(model);
            }
        }
        return models;
    }

    public List<GridLevelTreeNode> getRcsxLevelTreeList(String sxbm){
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria1 = example.createCriteria();
        GridItemDailyExample.Criteria criteria2 = example.createCriteria();
        criteria1.andIsValidEqualTo("1");
        if (StringUtils.isNotBlank(sxbm) && !sxbm.equals("rcsx")) {
            criteria1.andSjflLike("%" + sxbm + "%");
            criteria2.andSxbmEqualTo(sxbm);
            example.or(criteria2);
        }
        example.setOrderByClause(" sxbm asc ");
        List<GridItemDaily> bsWgxxbList = gridItemDailyService.selectByExample(example);
        if(CollectionUtils.isEmpty(bsWgxxbList)){
            return new ArrayList<>();
        }
        List<GridLevelTreeNode> treeNodes = new ArrayList<>();
        for(GridItemDaily daily : bsWgxxbList){
            if (sxbm != null) {
                if (daily.getSxbm().equals(sxbm)) {
                    GridLevelTreeNode treeNode = new GridLevelTreeNode();
                    treeNode.setValue(daily.getId());
                    treeNode.setLabel(daily.getSxmc());
                    treeNode.setChildren(setRcsxLevelTreeChildren(bsWgxxbList, daily.getSxbm()));
                    treeNodes.add(treeNode);
                }
            }else{
                if (daily.getSjfl() == null || daily.getSjfl().equals("")) {
                    GridLevelTreeNode treeNode = new GridLevelTreeNode();
                    treeNode.setValue(daily.getId());
                    treeNode.setLabel(daily.getSxmc());
                    treeNode.setChildren(setRcsxLevelTreeChildren(bsWgxxbList, daily.getSxbm()));
                    treeNodes.add(treeNode);
                }
            }

        }
        return treeNodes;
    }

    private List<GridLevelTreeNode> setRcsxLevelTreeChildren(List<GridItemDaily> dailies, String sxbm){
        List<GridLevelTreeNode> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(dailies)){
            for(GridItemDaily daily : dailies){
                if (daily.getSjfl() != null && sxbm.equals(daily.getSjfl())){
                    GridLevelTreeNode treeNode = new GridLevelTreeNode();
                    treeNode.setValue(daily.getId());
                    treeNode.setLabel(daily.getSxmc());
                    treeNode.setChildren(setRcsxLevelTreeChildren(dailies, daily.getSxbm()));
                    list.add(treeNode);
                }
            }
        }
        return list;
    }


    public List<Map<String, Object>>  getFirstDwRcsxList() {
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria1=example.createCriteria();
        GridItemDailyExample.Criteria criteria2=example.createCriteria();
        criteria1.andIsValidEqualTo("1");
        criteria2.andIsValidEqualTo("1");
        example.setOrderByClause(" sxbm asc ");
        List<GridItemDaily> bsWgxxbList = gridItemDailyService.selectByExample(example);
        List<Map<String, Object>> jsTreeModels = DwconvertFromDocTypes(bsWgxxbList,null);
        return jsTreeModels;
    }

    private List<Map<String, Object>> DwconvertFromDocTypes(List<GridItemDaily> recDocTypes,String sxbm) {
        List<Map<String, Object>> models = new ArrayList<>();
        if (!CollectionUtils.isEmpty(recDocTypes)) {
            for (GridItemDaily docType : recDocTypes) {
                if(sxbm != null){
                    if (docType.getSxbm().equals(sxbm)){
                        Map<String, Object> model = new HashMap<>();
                        model.put("id", docType.getId());
                        model.put("sxbm", docType.getSxbm());
                        model.put("sxmc", docType.getSxmc());
                        model.put("sjfl", docType.getSjfl());
                        model.put("clsx", docType.getClsx()==null?"":docType.getClsx());
                        model.put("zyccbm", docType.getZyccbm()==null?"":docType.getZyccbm());
                        model.put("lhccbm", docType.getLhccbm()==null?"":docType.getLhccbm());
                        model.put("createTime", docType.getCreateTime());
                        model.put("createBy", docType.getCreateBy());
                        model.put("updateTime", docType.getUpdateTime()==null?"":docType.getUpdateTime());
                        model.put("updateBy", docType.getUpdateBy()==null?"":docType.getUpdateBy());
                        model.put("isValid", docType.getIsValid());
                        model.put("fgld", docType.getFgld()==null?"":docType.getFgld());
                        model.put("ylzd1", docType.getYlzd1()==null?"":docType.getYlzd1());
                        model.put("ylzd2", docType.getYlzd2()==null?"":docType.getYlzd2());
                        model.put("ylzd3", docType.getYlzd3()==null?"":docType.getYlzd3());
                        model.put("ylzd4", docType.getYlzd4()==null?"":docType.getYlzd4());
                        model.put("ylzd5", docType.getYlzd5()==null?"":docType.getYlzd5());
                        List<Map<String,Object>> childrenDocTypes = DwconvertFromDocTypesByParent(recDocTypes,docType.getSxbm());
                        model.put("children", childrenDocTypes);
                        models.add(model);
                    }
                }else{
                    if (docType.getSjfl() == null || docType.getSjfl().equals("")){
                        Map<String, Object> model = new HashMap<>();
                        model.put("id", docType.getId());
                        model.put("sxbm", docType.getSxbm());
                        model.put("sxmc", docType.getSxmc());
                        model.put("sjfl", docType.getSjfl());
                        model.put("clsx", docType.getClsx()==null?"":docType.getClsx());
                        model.put("zyccbm", docType.getZyccbm()==null?"":docType.getZyccbm());
                        model.put("lhccbm", docType.getLhccbm()==null?"":docType.getLhccbm());
                        model.put("createTime", docType.getCreateTime());
                        model.put("createBy", docType.getCreateBy());
                        model.put("updateTime", docType.getUpdateTime()==null?"":docType.getUpdateTime());
                        model.put("updateBy", docType.getUpdateBy()==null?"":docType.getUpdateBy());
                        model.put("isValid", docType.getIsValid());
                        model.put("fgld", docType.getFgld()==null?"":docType.getFgld());
                        model.put("ylzd1", docType.getYlzd1()==null?"":docType.getYlzd1());
                        model.put("ylzd2", docType.getYlzd2()==null?"":docType.getYlzd2());
                        model.put("ylzd3", docType.getYlzd3()==null?"":docType.getYlzd3());
                        List<Map<String,Object>> childrenDocTypes = DwconvertFromDocTypesByParent(recDocTypes,docType.getSxbm());
                        model.put("children", childrenDocTypes);
                        models.add(model);
                    }
                }

            }
        }
        return models;
    }
}
