package com.ruoyi.system.domain.form.enums;

import java.util.HashMap;
import java.util.Map;

public enum EnumOutType {
    fix("fix","固定表单"),
    upper("upper","上级填报"),
    ;

    public String code;
    public String text;

    EnumOutType(String code, String text) {
        this.code = code;
        this.text = text;
    }

    public static Map<String, EnumOutType> maps = null;

    static
    {
        maps = new HashMap<>();
        for(EnumOutType it : EnumOutType.values())
        {
            maps.put(it.getCode(),it);
        }
    }

    public static EnumOutType getByCode(int code)
    {
        return maps.get(code);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

}
