package com.ruoyi.system.service.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridShop;
import com.ruoyi.system.domain.grid.GridShopExample;
import com.ruoyi.system.domain.grid.GridShopStaff;
import com.ruoyi.system.domain.grid.vo.GridShopSearchParam;
import com.ruoyi.system.domain.grid.vo.GridStatistic;
import com.ruoyi.system.domain.grid.vo.SimpleGridShopItem;
import com.ruoyi.system.service.BaseService;
import org.springframework.web.multipart.MultipartFile;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridShopService接口
 */
public interface GridShopService extends BaseService<GridShop, GridShopExample> {

    public AjaxResult addGridShop(GridShop wsShop) throws Exception;

    public AjaxResult updateGridShop(GridShop wsShop) throws Exception;

    //删除 商铺 人员 附件
    public AjaxResult batchRemove(Long[] ids);

    //新增商铺员工
    public AjaxResult addWsStaff(List<GridShopStaff> wsShopStaffs);

    //删除 商铺人员关系
    public int deleteShopStaff(Long[] ids);

    //商铺关联人口
    public AjaxResult ListGridPeople(int pageNum, int pageSize, Long shopId);

    //商铺列表
    public AjaxResult ListGridShop(GridShop wsShop);

    //单独查询商铺详情
    public GridShop getGridShopById(Long id);

    //商铺导入
    public AjaxResult dealImportExcel(MultipartFile file, String createBy);

    // 人口类型数量统计
    List<Map<String, Object>> countGridShop(String wgCode);

    // 商铺类型排序 取前五
    List<GridStatistic> countGridShopFive(String wgCode);

    // 商铺数量总量统计
    int countAll(String wgCode);

    // 各村社区数量统计
    List<Map<String, Object>> countGridShopByGrid();

    HashMap<String, BigDecimal> GridShopTypeStatistic(String wgCode);

    // 商铺 按网格分组统计数量
    List<GridStatistic> countGridShopGrid(String wgCode);

    List<GridShop> getAllShopList(GridShopSearchParam param);

    /**
     * 商铺点位列表
     * @param wgCode
     * @param name
     * @return
     */
    List<SimpleGridShopItem> getAllShopPointList(String wgCode, String name);

}
