package com.ruoyi.framework.task;

import com.ruoyi.common.utils.DateUtil;
import com.ruoyi.system.domain.visit.VisitFreePlan;
import com.ruoyi.system.domain.visit.vo.VisitPlanSearchParam;
import com.ruoyi.system.service.visit.VisitFreePlanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * * Author: brenda
 * * 2024/11/4
 **/
@EnableScheduling
@EnableAsync
@Component
public class VisitFreePlanDoneTask {

    private static final Logger LOGGER = LoggerFactory.getLogger(VisitFreePlanDoneTask.class);

    @Autowired
    private VisitFreePlanService visitFreePlanService;

    @Async
    @Scheduled(cron = "0 0 0 * * 1")
    public void execute(){
        VisitPlanSearchParam param = new VisitPlanSearchParam();
        List<String> hasDoneList = new ArrayList<>();
        hasDoneList.add("1");
        hasDoneList.add("2");
        param.setHasDoneList(hasDoneList);
        String endDate = DateUtil.getCurrentDate();
        param.setEndDate(endDate);
        List<VisitFreePlan> freePlanList = visitFreePlanService.listByParams(param);
        if(!CollectionUtils.isEmpty(freePlanList)){
            for(VisitFreePlan freePlan : freePlanList){
                freePlan.setHasDone("3");
                visitFreePlanService.updateByPrimaryKeySelective(freePlan);
                LOGGER.info("更新planModelId为"+freePlan.getPlanModelId()+"的走访任务为已结束");
            }
        }
    }
}
