package com.ruoyi.web.controller.video;

import cn.hutool.core.util.IdUtil;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.video.VideoDeviceChannel;
import com.ruoyi.system.domain.video.VideoDeviceInfo;
import com.ruoyi.system.domain.video.ext.*;
import com.ruoyi.system.service.video.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * * Author: brenda
 * * 2024/9/5
 **/
@RestController
@RequestMapping("api/video/data")
public class IccInfoController {

    @Autowired
    private VideoDeviceChannelService videoDeviceChannelService;

    @Autowired
    private VideoDeviceInfoService videoDeviceInfoService;

    @Autowired
    private IccTokenService iccTokenService;

    @Autowired
    private IccPreviewService iccPreview;

    @Autowired
    private IccCutPicService iccCutPic;

    @Autowired
    private IccInfoService iccInfo;

    @RequestMapping("/info")
    //获取设备和管道信息并写入数据库
    public AjaxResult getDevicePage(DevicePageRequest devicePageRequest){
        DevicePageResponse devicePageResponse = iccInfo.getDevicePage(devicePageRequest);
        List<DevicePageResponse.PageVO.DeviceInfoVO> data = devicePageResponse.getData().getPageData();
        for(int i = 0;i<data.size();i++){
            DevicePageResponse.PageVO.DeviceInfoVO deviceInfoVO = data.get(i);
            VideoDeviceInfo videoDeviceInfo = new VideoDeviceInfo();
            String deviceId = IdUtil.simpleUUID();
            videoDeviceInfo.setDeviceId(deviceId);
            videoDeviceInfo.setDeviceName(deviceInfoVO.getDeviceName());
            videoDeviceInfo.setDeviceCode(deviceInfoVO.getDeviceCode());
            videoDeviceInfo.setDeviceIp(deviceInfoVO.getDeviceIp());
            videoDeviceInfo.setDevicePort(deviceInfoVO.getDevicePort());
            videoDeviceInfoService.InsertVideoDeviceInfo(videoDeviceInfo);

            List<DevicePageResponse.PageVO.DeviceInfoVO.UnitVO.ChannelVO> channel = data.get(i).getUnits().get(0).getChannels();
            for(int j = 0;j<channel.size();j++){
                DevicePageResponse.PageVO.DeviceInfoVO.UnitVO.ChannelVO channelVO = channel.get(j);
                VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
                videoDeviceChannel.setChannelCode(channelVO.getChannelCode());
                videoDeviceChannel.setChannelName(channelVO.getChannelName());
                videoDeviceChannel.setChannelSeq(channelVO.getChannelSeq());
                videoDeviceChannel.setChannelSn(channelVO.getChannelSn());
                videoDeviceChannel.setChannelType(channelVO.getChannelType());
                videoDeviceChannel.setCapability(channelVO.getCapability());
                videoDeviceChannel.setParentId(deviceId);
                videoDeviceChannel.setChannelId(IdUtil.simpleUUID());
                videoDeviceChannelService.InsertVideoDeviceChannel(videoDeviceChannel);
            }
        }

        return AjaxResult.success(devicePageResponse);
    }

    @RequestMapping("/update")
    public AjaxResult updateInfo() throws Exception {
        VideoDeviceChannel videoDeviceChannel = new VideoDeviceChannel();
        List<VideoDeviceChannel> videoDeviceChannelList = videoDeviceChannelService.selectVideoDeviceChannelList(videoDeviceChannel);
        String code="",url="",img="";
        for(int i = 0 ; i < videoDeviceChannelList.size() ; i++){
            code = videoDeviceChannelList.get(i).getChannelCode();
            HlsUrlRequest hlsUrlRequest = new HlsUrlRequest();
            hlsUrlRequest.setData(new HlsUrlRequest.Data());
            hlsUrlRequest.getData().setChannelId(code);
            hlsUrlRequest.getData().setType("hls");
            hlsUrlRequest.getData().setStreamType("1");
            HlsUrlResponse hlsUrlResponse = iccPreview.getHlsUrl(hlsUrlRequest);
            hlsUrlRequest.getData().setStreamType("2");
            url = hlsUrlResponse.getData().getUrl() + "?token=" + iccTokenService.getToken();
            img = iccCutPic.remoteCapture(2L,code);

            VideoDeviceChannel videoDeviceChannel1 = new VideoDeviceChannel();
            videoDeviceChannel1.setChannelCode(code);
            videoDeviceChannel1.setUrl(url);
            videoDeviceChannel1.setImg(img);

            videoDeviceChannelService.UpdateVideoDeviceChannel(videoDeviceChannel1);
        }
        return AjaxResult.success();
    }
}
