package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridInterview;
import com.ruoyi.system.service.grid.GridInterviewService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : peter
 * @description: TODO
 * @date : 2022-05-31 15:29
 */
@Api(tags = "网格管理 - 企业/商铺安全走访日志")
@RestController
@RequestMapping("/api/grid/interview")
public class InterviewController {

    @Autowired
    private GridInterviewService gridInterviewService;

    /**
     * 走访日志列表
     */
    @GetMapping(value = "/page")
    public AjaxResult interviewPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                    @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                    @RequestParam(value = "cid") String cid) {
        try {
            PageHelper.startPage(pageNum, pageSize);
            PageInfo<GridInterview> pageInfo = new PageInfo<>(gridInterviewService.interviewPage(cid));
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * 走访日志新增
     */
    @PostMapping(value = "/add")
    public AjaxResult interviewAdd(@RequestBody GridInterview wsInterview) {
        return AjaxResult.success(gridInterviewService.interviewAdd(wsInterview));
    }

    /**
     * 走访日志编辑
     */
    @PostMapping(value = "/edit")
    public AjaxResult interviewEdit(@RequestBody GridInterview wsInterview) {
        gridInterviewService.edit(wsInterview);
        return AjaxResult.success(null);
    }

    /**
     * 走访日志详情
     */
    @GetMapping(value = "/detail/{id}")
    public AjaxResult interviewDetail(@PathVariable("id") String id) {
        return AjaxResult.success(gridInterviewService.detail(id));
    }

    /**
     * 走访日志删除
     */
    @GetMapping(value = "/delete")
    public AjaxResult interviewDelete(@RequestParam(value = "ids") String ids) {
        gridInterviewService.delete(ids);
        return AjaxResult.success(null);
    }

    /**
     * 30天内走访日志数量
     *
     * @param type 1-人口 2-住宅 3-企业 4-商铺
     * @param id   对象的id
     * @return
     */
    @GetMapping(value = "/count")
    public AjaxResult interviewCount(@RequestParam(value = "type") String type,
                                       @RequestParam(value = "id") String id) {
        return AjaxResult.success(gridInterviewService.count(type, id));
    }

    /**
     * 判断该对象（企业，房屋，商铺有无绑定人）下面有无绑定
     *
     * @param type 1-人口 2-住宅 3-企业 4-商铺
     * @param id   对象的id
     * @return
     */
    @GetMapping(value = "/pending")
    public AjaxResult pending(@RequestParam(value = "type") String type,
                                @RequestParam(value = "id") String id) {
        long a = gridInterviewService.pending(type, id);
        if (a > 0) {
            return AjaxResult.success(true);
        } else {
            return AjaxResult.success(false);
        }

    }
}
