/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.matcher;

import com.taobao.arthas.core.util.matcher.Matcher;

public class WildcardMatcher
implements Matcher<String> {
    private final String pattern;
    private static final Character ASTERISK = Character.valueOf('*');
    private static final Character QUESTION_MARK = Character.valueOf('?');
    private static final Character ESCAPE = Character.valueOf('\\');

    public WildcardMatcher(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matching(String target) {
        return this.match(target, this.pattern, 0, 0);
    }

    private boolean match(String target, String pattern, int stringStartNdx, int patternStartNdx) {
        if (target == null || pattern == null) {
            return false;
        }
        int pNdx = patternStartNdx;
        int sNdx = stringStartNdx;
        int pLen = pattern.length();
        if (pLen == 1 && pattern.charAt(0) == ASTERISK.charValue()) {
            return true;
        }
        int sLen = target.length();
        boolean nextIsNotWildcard = false;
        while (true) {
            if (sNdx >= sLen) {
                while (pNdx < pLen && pattern.charAt(pNdx) == ASTERISK.charValue()) {
                    ++pNdx;
                }
                return pNdx >= pLen;
            }
            if (pNdx >= pLen) {
                return false;
            }
            char p = pattern.charAt(pNdx);
            if (!nextIsNotWildcard) {
                if (p == ESCAPE.charValue()) {
                    ++pNdx;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (p == QUESTION_MARK.charValue()) {
                    ++sNdx;
                    ++pNdx;
                    continue;
                }
                if (p == ASTERISK.charValue()) {
                    char pnext = '\u0000';
                    if (pNdx + 1 < pLen) {
                        pnext = pattern.charAt(pNdx + 1);
                    }
                    if (pnext == ASTERISK.charValue()) {
                        ++pNdx;
                        continue;
                    }
                    ++pNdx;
                    for (int i = target.length(); i >= sNdx; --i) {
                        if (!this.match(target, pattern, i, pNdx)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (p != target.charAt(sNdx)) {
                return false;
            }
            ++sNdx;
            ++pNdx;
        }
    }
}

