/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.system.impl;

import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobListener;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.impl.JobControllerImpl;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class JobImpl
implements Job {
    final int id;
    final JobControllerImpl controller;
    final Process process;
    final String line;
    private volatile Session session;
    private volatile ExecStatus actualStatus;
    volatile long lastStopped;
    volatile JobListener jobHandler;
    volatile Handler<ExecStatus> statusUpdateHandler;
    volatile Date timeoutDate;
    final Future<Void> terminateFuture;
    final AtomicBoolean runInBackground;

    JobImpl(int id, JobControllerImpl controller, Process process, String line, boolean runInBackground, Session session, JobListener jobHandler) {
        this.id = id;
        this.controller = controller;
        this.process = process;
        this.line = line;
        this.session = session;
        this.terminateFuture = Future.future();
        this.runInBackground = new AtomicBoolean(runInBackground);
        this.jobHandler = jobHandler;
        if (jobHandler == null) {
            throw new IllegalArgumentException("JobListener is required");
        }
        process.terminatedHandler(new TerminatedHandler(controller));
    }

    public ExecStatus actualStatus() {
        return this.actualStatus;
    }

    @Override
    public boolean interrupt() {
        return this.process.interrupt();
    }

    @Override
    public Job resume() {
        return this.resume(true);
    }

    @Override
    public Date timeoutDate() {
        return this.timeoutDate;
    }

    @Override
    public void setTimeoutDate(Date date) {
        this.timeoutDate = date;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Job resume(boolean foreground) {
        try {
            this.process.resume(foreground, new ResumeHandler());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.runInBackground.set(!foreground);
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle(this.process.status());
        }
        if (this.status() == ExecStatus.RUNNING) {
            if (foreground) {
                this.jobHandler.onForeground(this);
            } else {
                this.jobHandler.onBackground(this);
            }
        }
        return this;
    }

    @Override
    public Job suspend() {
        try {
            this.process.suspend(new SuspendHandler());
        }
        catch (IllegalStateException ignore) {
            return this;
        }
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle(this.process.status());
        }
        this.jobHandler.onSuspend(this);
        return this;
    }

    @Override
    public void terminate() {
        try {
            this.process.terminate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.controller.removeJob(this.id);
    }

    @Override
    public Process process() {
        return this.process;
    }

    @Override
    public ExecStatus status() {
        return this.process.status();
    }

    @Override
    public String line() {
        return this.line;
    }

    @Override
    public boolean isRunInBackground() {
        return this.runInBackground.get();
    }

    @Override
    public Job toBackground() {
        if (!this.runInBackground.get() && this.runInBackground.compareAndSet(false, true)) {
            this.process.toBackground();
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle(this.process.status());
            }
            this.jobHandler.onBackground(this);
        }
        return this;
    }

    @Override
    public Job toForeground() {
        if (this.runInBackground.get() && this.runInBackground.compareAndSet(true, false)) {
            this.process.toForeground();
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle(this.process.status());
            }
            this.jobHandler.onForeground(this);
        }
        return this;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Job run() {
        return this.run(!this.runInBackground.get());
    }

    @Override
    public Job run(boolean foreground) {
        this.actualStatus = ExecStatus.RUNNING;
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle(ExecStatus.RUNNING);
        }
        this.process.setSession(this.session);
        this.process.run(foreground);
        if (this.status() == ExecStatus.RUNNING) {
            if (foreground) {
                this.jobHandler.onForeground(this);
            } else {
                this.jobHandler.onBackground(this);
            }
        }
        return this;
    }

    private class SuspendHandler
    implements Handler<Void> {
        private SuspendHandler() {
        }

        @Override
        public void handle(Void event) {
            JobImpl.this.actualStatus = ExecStatus.STOPPED;
        }
    }

    private class ResumeHandler
    implements Handler<Void> {
        private ResumeHandler() {
        }

        @Override
        public void handle(Void event) {
            JobImpl.this.actualStatus = ExecStatus.RUNNING;
        }
    }

    private class TerminatedHandler
    implements Handler<Integer> {
        private final JobControllerImpl controller;

        public TerminatedHandler(JobControllerImpl controller) {
            this.controller = controller;
        }

        @Override
        public void handle(Integer exitCode) {
            JobImpl.this.jobHandler.onTerminated(JobImpl.this);
            this.controller.removeJob(JobImpl.this.id);
            if (JobImpl.this.statusUpdateHandler != null) {
                JobImpl.this.statusUpdateHandler.handle(ExecStatus.TERMINATED);
            }
            JobImpl.this.terminateFuture.complete();
        }
    }
}

