package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyEconomyInfo;
import com.ruoyi.system.domain.grid.GridCompanyEconomyInfoExample;
import com.ruoyi.system.domain.grid.ext.*;
import com.ruoyi.system.service.BaseService;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridCompanyEconomyInfoService接口
 */
public interface GridCompanyEconomyInfoService extends BaseService<GridCompanyEconomyInfo, GridCompanyEconomyInfoExample> {

    // 根据统一社会信用代码,归属月份查询企业经济数据
    List<GridCompanyEconomyInfo> listEconomyInfos(String companyId, String year);

    PageInfo<GridCompanyEcoInfoBean> pageEconomyInfos(Integer pageNo, Integer pageSize, String year, String qylxCode, String companyKeyword, String orderValue, String orderType);

    GridCompanyEconomyInfo detail(String id);

    void save(GridCompanyEconomyInfoExt economyInfo);

    boolean checkIsExist(String year, String companyId);

    AjaxResult importExcel(MultipartFile file);

    void delete(String id);

    // 亩均经济比例
    Map perMuCount(String year);

    //亩均经济比例 不返回列表款
    List<GridCompanyEconomyPermuItem> listPerMuByYear(String year);

    // 村级销售排名
    List<GridCompanyEconomyInfoSaleBean> saleCount(String year);

    // 村级税收排名
    List<GridCompanyEconomyInfoSaleBean> taxCount(String year);

    // 地块信息统计
    GridCompanyLandInfoBean loadCompanyLandInfo(String landId, String year);

    // 企业信息列表
    List<GridCompanyEcoInfoBean> loadCompanyEcoInfos(String type, String year, String searchName);
}
