/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.term.Device;
import io.termd.core.term.TermInfoBuilder;
import io.termd.core.term.TermInfoParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;

public class TermInfo {
    private static final TermInfo DEFAULT = TermInfo.loadDefault();
    final Map<String, Device> devices;

    private static TermInfo loadDefault() {
        try {
            InputStream in = TermInfo.class.getResourceAsStream("terminfo.src");
            TermInfoParser parser = new TermInfoParser(new InputStreamReader(in, "US-ASCII"));
            TermInfoBuilder builder = new TermInfoBuilder();
            parser.parseDatabase(builder);
            return builder.build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static TermInfo defaultInfo() {
        return DEFAULT;
    }

    TermInfo(Map<String, Device> devices) {
        this.devices = devices;
    }

    public Device getDevice(String name) {
        return this.devices.get(name);
    }

    public Collection<Device> devices() {
        return this.devices.values();
    }
}

