/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.MethodVO;
import com.taobao.arthas.core.command.model.SearchMethodModel;
import com.taobao.arthas.core.command.view.ClassLoaderView;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.text.util.RenderUtil;

public class SearchMethodView
extends ResultView<SearchMethodModel> {
    @Override
    public void draw(CommandProcess process, SearchMethodModel result) {
        if (result.getMatchedClassLoaders() != null) {
            process.write("Matched classloaders: \n");
            ClassLoaderView.drawClassLoaders(process, result.getMatchedClassLoaders(), false);
            process.write("\n");
            return;
        }
        boolean detail = result.isDetail();
        MethodVO methodInfo = result.getMethodInfo();
        if (detail) {
            if (methodInfo.isConstructor()) {
                process.write(RenderUtil.render(ClassUtils.renderConstructor(methodInfo), process.width()) + "\n");
            } else {
                process.write(RenderUtil.render(ClassUtils.renderMethod(methodInfo), process.width()) + "\n");
            }
        } else {
            process.write(methodInfo.getDeclaringClass()).write(" ").write(methodInfo.getMethodName()).write(methodInfo.getDescriptor()).write("\n");
        }
    }
}

