package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.ext.GridCompanyLawArchivesExt;
import com.ruoyi.system.domain.grid.vo.GridCompanyLawArchivesParam;
import com.ruoyi.system.service.grid.GridCompanyLawArchivesService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 企业执法档案
 */
@Api(tags = "公司信息-执法档案")
@RestController
@RequestMapping("/api/grid/company/lawArchives")
public class CompanyLawArchivesController {

    @Autowired
    GridCompanyLawArchivesService wsCompanyLawArchivesService;

    /**
     * 分页查询执法档案列表
     */
    @GetMapping(value = "/page")
    public AjaxResult page(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                           @RequestParam(name = "archivesNo", required = false) String archivesNo,
                           @RequestParam(name = "wgCode", required = false) String wgCode,
                           @RequestParam(name = "companyId", required = false) String companyId,
                           @RequestParam(name = "companyName", required = false) String companyName,
                           @RequestParam(name = "companyType", required = false) String companyType,
                           @RequestParam(name = "createUserId", required = false) String createUserId,
                           @RequestParam(name = "creditCode", required = false) String creditCode,
                           @RequestParam(name = "archivesType", required = false) String archivesType,
                           @RequestParam(name = "startTime", required = false) String startTime,
                           @RequestParam(name = "endTime", required = false) String endTime) {
        GridCompanyLawArchivesParam param = new GridCompanyLawArchivesParam();
        param.setWgCode(wgCode);
        param.setCompanyName(companyName);
        param.setCompanyType(companyType);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setCompanyId(companyId);
        param.setCreateUserId(createUserId);
        param.setCreditCode(creditCode);
        param.setArchivesType(archivesType);
        param.setArchivesNo(archivesNo);
        return AjaxResult.success(wsCompanyLawArchivesService.pageInfos(param, pageNo, pageSize));
    }

    /**
     * 保存
     */
    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody GridCompanyLawArchivesExt archivesExt) {
        wsCompanyLawArchivesService.save(archivesExt);
        return AjaxResult.success("提交成功");
    }

    /**
     * 保存
     */
    @PostMapping(value = "/update")
    public AjaxResult update(@RequestBody GridCompanyLawArchivesExt archivesExt) {
        wsCompanyLawArchivesService.update(archivesExt);
        return AjaxResult.success("提交成功");
    }

    /**
     * 详情
     */
    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") String id) {
        return AjaxResult.success(wsCompanyLawArchivesService.detail(id));
    }

    /**
     * 删除
     */
    @GetMapping(value = "/delete/{id}")
    public AjaxResult delete(@PathVariable("id") String id) {
        wsCompanyLawArchivesService.delete(id);
        return AjaxResult.success("删除成功");
    }
}
