package com.ruoyi.web.controller.form;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.form.MdFormTemplate;
import com.ruoyi.system.domain.form.params.FormTemplateQuery;
import com.ruoyi.system.service.form.FormTemplateManager;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 表单模板
 */
@Api(tags = "在线表单 - 表单模板")
@RestController
@RequestMapping("/api/form/template")
public class FormTemplateController extends BaseController {
    @Autowired
    private FormTemplateManager formTemplateManager;

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //模板 查询
     * @Date 10:36 2020/8/17
     * @Param [query]
     **/
    @GetMapping(value = "/list")
    @ResponseBody
    public AjaxResult list(FormTemplateQuery mdFormTemplate) {
        try {
            //query.setStatus(EnumFormStatus.normal.code);
            return AjaxResult.success(formTemplateManager.queryAll(mdFormTemplate));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //模板计数
     * @Date 18:40 2020/8/20
     * @Param [mdFormTemplate]
     **/
    @GetMapping(value = "/templateCount")
    @ResponseBody
    public AjaxResult templateCount(MdFormTemplate mdFormTemplate) {
        try {
            //query.setStatus(EnumFormStatus.normal.code);
            return AjaxResult.success(formTemplateManager.templateCount(mdFormTemplate));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //模板 查询
     * @Date 10:36 2020/8/17
     * @Param [query]
     **/
    @GetMapping(value = "/selectOneById")
    @ResponseBody
    public AjaxResult selectOneById(String id) {
        if (StringUtils.isEmpty(id)) {
            return AjaxResult.build(400, "参数异常", "id不能为空");
        }
        try {
            //query.setStatus(EnumFormStatus.normal.code);
            return AjaxResult.success(formTemplateManager.queryOneWithBlob(id));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //创建模板
     * @Date 13:28 2020/8/17
     * @Param [mdFormCategory]
     **/
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult saveOrUpdateSetting(@RequestBody MdFormTemplate mdFormTemplate) {
        try {
            int count = formTemplateManager.saveOrUpdate(mdFormTemplate);
            if (count > 0) {
                return AjaxResult.success("操作成功");
            }
            return AjaxResult.build(500, "服务器内部错误", "操作失败");
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(400, "模板名称已存在！", e.getMessage());
        }
    }

    @RequestMapping(value = "/deleteById", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult deleteById(@RequestBody MdFormTemplate mdFormTemplate) {
        try {
            //query.setStatus(EnumFormStatus.normal.code);
            int count = formTemplateManager.deleteById(mdFormTemplate.getId());
            if (count > 0) {
                return AjaxResult.success("删除成功");
            }
            return AjaxResult.build(500, "服务器内部错误", "删除失败");
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

}

