/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.usage;

import com.taobao.middleware.cli.Argument;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.UsageMessageFormatter;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Style;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.Collections;

public class StyledUsageFormatter
extends UsageMessageFormatter {
    private Color fontColor;

    public StyledUsageFormatter(Color fontColor) {
        this.fontColor = fontColor;
    }

    public static String styledUsage(CLI cli, int width) {
        if (cli == null) {
            return "";
        }
        StringBuilder usageBuilder = new StringBuilder();
        StyledUsageFormatter formatter = new StyledUsageFormatter(Color.green);
        formatter.setWidth(width);
        cli.usage(usageBuilder, formatter);
        return usageBuilder.toString();
    }

    @Override
    public void usage(StringBuilder builder, String prefix, CLI cli) {
        TableElement table = new TableElement(1, 2).leftCellPadding(1).rightCellPadding(1);
        table.add(Element.row().add(Element.label("USAGE:").style(this.getHighlightedStyle())));
        table.add(Element.row().add(Element.label(this.computeUsageLine(prefix, cli))));
        table.add(Element.row().add(""));
        table.add(Element.row().add(Element.label("SUMMARY:").style(this.getHighlightedStyle())));
        table.add(Element.row().add(Element.label("  " + cli.getSummary())));
        if (cli.getDescription() != null) {
            String[] descLines;
            for (String line : descLines = cli.getDescription().split("\\n")) {
                if (this.shouldBeHighlighted(line)) {
                    table.add(Element.row().add(Element.label(line).style(this.getHighlightedStyle())));
                    continue;
                }
                table.add(Element.row().add(Element.label(line)));
            }
        }
        if (!cli.getOptions().isEmpty() || !cli.getArguments().isEmpty()) {
            table.add(Element.row().add(""));
            table.row(Element.label("OPTIONS:").style(this.getHighlightedStyle()));
            for (Option option : cli.getOptions()) {
                StringBuilder optionSb = new StringBuilder(32);
                if (StyledUsageFormatter.isNullOrEmpty(option.getShortName())) {
                    optionSb.append("   ");
                } else {
                    optionSb.append('-').append(option.getShortName());
                    if (StyledUsageFormatter.isNullOrEmpty(option.getLongName())) {
                        optionSb.append(' ');
                    } else {
                        optionSb.append(',');
                    }
                }
                if (!StyledUsageFormatter.isNullOrEmpty(option.getLongName())) {
                    optionSb.append(" --").append(option.getLongName());
                }
                if (option.acceptValue()) {
                    optionSb.append(" <value>");
                }
                table.add(Element.row().add(Element.label(optionSb.toString()).style(this.getHighlightedStyle())).add(option.getDescription()));
            }
            for (Argument argument : cli.getArguments()) {
                table.add(Element.row().add(Element.label("<" + argument.getArgName() + ">").style(this.getHighlightedStyle())).add(argument.getDescription()));
            }
        }
        builder.append(RenderUtil.render(table, this.getWidth()));
    }

    private Style.Composite getHighlightedStyle() {
        return Style.style(Decoration.bold, this.fontColor);
    }

    public String computeUsageLine(String prefix, CLI cli) {
        StringBuilder buff;
        if (prefix == null) {
            buff = new StringBuilder("  ");
        } else {
            buff = new StringBuilder("  ").append(prefix);
            if (!prefix.endsWith(" ")) {
                buff.append(" ");
            }
        }
        buff.append(cli.getName()).append(" ");
        if (this.getOptionComparator() != null) {
            Collections.sort(cli.getOptions(), this.getOptionComparator());
        }
        for (Option option : cli.getOptions()) {
            this.appendOption(buff, option);
            buff.append(" ");
        }
        for (Argument arg : cli.getArguments()) {
            this.appendArgument(buff, arg, arg.isRequired());
            buff.append(" ");
        }
        return buff.toString();
    }

    private boolean shouldBeHighlighted(String line) {
        return !line.startsWith(" ");
    }
}

