package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridShop;
import com.ruoyi.system.domain.grid.GridShopStaff;
import com.ruoyi.system.domain.grid.vo.GridShopSearchParam;
import com.ruoyi.system.mapper.grid.GridShopMapper;
import com.ruoyi.system.service.grid.GridShopService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;


@Api(tags = "网格管理 - 商铺管理")
@RestController
@RequestMapping("/api/grid/shop")
public class ShopController {

    @Autowired
    GridShopService gridShopService;
    @Autowired
    GridShopMapper gridShopMapper;

    /**
     * 保存
     */
    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody GridShop wsShop) throws Exception {
        return gridShopService.addGridShop(wsShop);
    }

    /**
     * 更新
     */
    @PutMapping(value = "/update")
    public AjaxResult update(@RequestBody GridShop wsShop) throws Exception {
        return gridShopService.updateGridShop(wsShop);
    }

    //删除 商铺 人员 附件
    @DeleteMapping(value = "/deleteShop")
    public AjaxResult batchRemove(@RequestBody Long[] ids) {
        return gridShopService.batchRemove(ids);
    }

    //新增 商铺人员关系
    @PostMapping(value = "/addShopStaff")
    public AjaxResult addShopStaff(@RequestBody List<GridShopStaff> wsShopStaffList) {
        return gridShopService.addWsStaff(wsShopStaffList);
    }

    //删除 商铺人员关系
    @DeleteMapping(value = "/deleteShopStaff")
    public AjaxResult deleteShopStaff(@RequestBody Long[] ids) {
        return AjaxResult.success(gridShopService.deleteShopStaff(ids));
    }

    //商铺人员列表
    @GetMapping(value = "/ListGridShopPeople")
    public AjaxResult ListGridPeople(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                     @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                     @RequestParam(value = "shopId") Long shopId
    ) {
        return gridShopService.ListGridPeople(pageNum, pageSize, shopId);
    }

    //商铺列表
    @GetMapping()
    public AjaxResult ListGridShop(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                   @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                   @RequestParam(value = "wgCode", required = false) String wgCode,
                                   @RequestParam(value = "belongArea", required = false) String belongArea,
                                   @RequestParam(value = "shopType", required = false) String shopType,
                                   @RequestParam(value = "shopName", required = false) String shopName
    ) {
        GridShop wsShop = new GridShop();
        wsShop.setPageNum(pageNum);
        wsShop.setPageSize(pageSize);
        wsShop.setWgCode(wgCode);
        wsShop.setShopType(shopType);
        wsShop.setShopName(shopName);
        wsShop.setBelongArea(belongArea);
        return gridShopService.ListGridShop(wsShop);
    }

    //单独查询商铺详情
    @GetMapping(value = "/{id}")
    public AjaxResult getById(@PathVariable("id") Long id) throws Exception {
        return AjaxResult.success(gridShopService.getGridShopById(id));
    }

    @PostMapping("/importExcel")
    public AjaxResult dealImportExcel(@RequestParam("file") MultipartFile file,
                                      @RequestParam("createBy") String createBy) {
        return gridShopService.dealImportExcel(file, createBy);
    }

//    @GetMapping("/statistic/GridShopType")
//    public AjaxResult GridShopTypeStatistic(@RequestParam(value = "wgCode", required = false) String wgCode) {
//        return AjaxResult.success(gridShopService.GridShopTypeStatistic(wgCode));
//    }

//    @GetMapping("/statistic/GridShopTypeNum")
//    public AjaxResult countGridShop(@RequestParam(value = "wgCode", required = false) String wgCode) {
//        return AjaxResult.success(gridShopService.countGridShopFive(wgCode));
//    }

//    @GetMapping("/statistic/GridShopGridNum")
//    public AjaxResult countGridShopGrid(@RequestParam(value = "wgCode", required = false) String wgCode) {
//        return AjaxResult.success(gridShopService.countGridShopGrid(wgCode));
//    }

    @GetMapping("/statistic/GridShopNum")
    public AjaxResult countAll(@RequestParam(value = "wgCode", required = false) String wgCode) {
        return AjaxResult.success(gridShopService.countAll(wgCode));
    }

    @ApiOperation("所有商铺列表")
    @GetMapping("/allShopList")
    public AjaxResult getShopList(@RequestParam(value = "wgCode")String wgCode){
        GridShopSearchParam param = new GridShopSearchParam();
        if(StringUtils.isNotBlank(wgCode)){
            param.setWgCodeLikes(Arrays.asList(wgCode));
        }
        return AjaxResult.success(gridShopService.getAllShopList(param));
    }

    @GetMapping("/saveLabel")
    public AjaxResult saveLabel(@RequestParam(value = "id")String id,@RequestParam(value = "label")String label){
        return AjaxResult.success(gridShopMapper.insertLabelById(id,label));
    }

    @GetMapping("/selectLabel")
    public AjaxResult selectLabel(@RequestParam(value = "id")String id){
        return AjaxResult.success(gridShopMapper.selectLabelById(id));
    }
}
