package com.ruoyi.web.controller.task.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author vidar
 * date 2024/7/17
 * description
 */
@Data
@ApiModel("工单 开始处理 request")
public class StartTaskRequest {
    @ApiModelProperty("id")
    @NotBlank(message = "工单id不能为空")
    private String id;
    @ApiModelProperty("登录人id")
    @NotBlank(message = "登陆人id不能为空")
    private String loginUserId;
    @ApiModelProperty("登陆人name")
    @NotBlank(message = "登陆人name不能为空")
    private String loginUserName;
    @ApiModelProperty("登录人所属网格 code")
    @NotBlank(message = "登录人所属网格code不能为空")
    private String loginWgCode;
    @ApiModelProperty("当前登录人角色")
    @NotBlank(message = "登录人角色等级不能为空")
    private String loginUserRole;
    @ApiModelProperty("登录人所属网格")
    private String loginUserBelongGrid;
    @ApiModelProperty("上传的照片")
    private String performPicture;
    @ApiModelProperty("上传说明")
    private String performNode;
}
