package com.ruoyi.web.controller.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyLandRemark;
import com.ruoyi.system.service.grid.GridCompanyLandRemarkService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : yaoqiang
 * @description: 经济地块与企业关联备注
 * @date : 2023-04-23 11:09
 */
@Api(tags = "网格管理 - 经济地块与企业关联备注")
@RestController
@RequestMapping("/api/grid/company/land/remark")
public class CompanyLandRemarkController {

    @Autowired
    private GridCompanyLandRemarkService gridCompanyLandRemarkService;


    @GetMapping(value = "/page")
    public AjaxResult page(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        return AjaxResult.success(gridCompanyLandRemarkService.page(pageNo, pageSize));
    }

    /**
     * 保存/修改
     */
    @PostMapping(value = "/saveOrUpdate")
    public AjaxResult saveOrUpdate(@RequestBody GridCompanyLandRemark wsCompanyLandRemark) {
        return gridCompanyLandRemarkService.saveOrUpdate(wsCompanyLandRemark);
    }

    /**
     * 详情
     */
    @GetMapping(value = "/detail")
    public AjaxResult detail(@RequestParam(name = "companyId", required = false) String companyId) {
        return AjaxResult.success(gridCompanyLandRemarkService.detail(companyId));
    }

}
