package com.ruoyi.web.controller.publicservice;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.publicservice.TPublicServiceIsound;
import com.ruoyi.system.service.publicservice.TPublicServiceIsoundService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 公共服务 我发声表
 *
 * @author wujm<wujm @ eazytec.com>
 */
@Api(tags = "公共服务-我发声")
@RestController
@RequestMapping("/api/publicservice/iSound")
public class TPublicServiceIsoundController extends BaseController {
	
    @Autowired
    private TPublicServiceIsoundService tPublicServiceIsoundService;

    @GetMapping(value = "/getMaxNo")
    public AjaxResult getMaxNo() {
        return AjaxResult.success(tPublicServiceIsoundService.getMaxNum());
    }

    /**
     * 列表
     *
     * @param tPublicServiceIsound
     * @return
     */
    @GetMapping()
    public TableDataInfo list(TPublicServiceIsound tPublicServiceIsound) {
        startPage();
        return getDataTable(tPublicServiceIsoundService.listTPublicServiceIsound(tPublicServiceIsound));
    }

    /**
     * 新增
     *
     * @param tPublicServiceIsound
     * @return
     */
    @Log(title = "新增公共服务 我发声表", businessType = BusinessType.INSERT)
    @PostMapping()
    public AjaxResult save(@RequestBody TPublicServiceIsound tPublicServiceIsound) {
        tPublicServiceIsound.setCreateBy(getUserId());
        return toAjax(tPublicServiceIsoundService.saveISound(tPublicServiceIsound));
    }

    /**
     * 根据id查询详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getById(@PathVariable("id") Long id) {
        return AjaxResult.success(tPublicServiceIsoundService.getIsoundById(id));
    }

    /**
     * 修改
     *
     * @param tPublicServiceIsound
     * @return
     */
    @Log(title = "修改公共服务 我发声表", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult update(@RequestBody TPublicServiceIsound tPublicServiceIsound) {
        tPublicServiceIsound.setUpdateBy(getUserId());
        return toAjax(tPublicServiceIsoundService.updateIsound(tPublicServiceIsound, getUsername()));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Log(title = "删除公共服务 我发声表", businessType = BusinessType.DELETE)
    @DeleteMapping("/delete")
    public AjaxResult batchRemove(@RequestBody Long[] ids) {
        return toAjax(tPublicServiceIsoundService.batchRemove(ids));
    }

}
