package com.ruoyi.system.service.house.impl;

import com.ruoyi.system.domain.house.HouseResourceAssociationObject;
import com.ruoyi.system.mapper.house.HouseResourceAssociationObjectMapper;
import com.ruoyi.system.service.house.HouseResourceAssociationObjectService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.UUID;

@Service
public class HouseResourceAssociationObjectServiceImpl implements HouseResourceAssociationObjectService {

    private final HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper;

    public HouseResourceAssociationObjectServiceImpl(HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper) {
        this.houseResourceAssociationObjectMapper = houseResourceAssociationObjectMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveHouseResourceAssociationObject(HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObject.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        houseResourceAssociationObjectMapper.insertHouseResourceObjectAssociation(houseResourceAssociationObject);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateHouseResourceAssociationObject(HouseResourceAssociationObject houseResourceAssociationObject) {
        houseResourceAssociationObjectMapper.updateHouseResourceObjectAssociation(houseResourceAssociationObject);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteHouseResourceAssociationObjectById(String id) {
        houseResourceAssociationObjectMapper.deleteHouseResourceObjectAssociationById(id);
    }

    @Override
    public HouseResourceAssociationObject queryHouseResourceAssociationObjectByHouseResourceIdType(String houseResourceId, int type) {
        return houseResourceAssociationObjectMapper.selectHouseResourceObjectAssociationByHouseResourceIdType(houseResourceId, type);
    }
}
