package com.ruoyi.system.service.grid.impl;

import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.system.domain.grid.GridCompany;
import com.ruoyi.system.domain.grid.GridCompanyPeople;
import com.ruoyi.system.domain.grid.GridCompanyPeopleExample;
import com.ruoyi.system.domain.grid.GridPeople;
import com.ruoyi.system.domain.grid.ext.GridCompanyExt;
import com.ruoyi.system.domain.grid.ext.GridCompanyPeopleExt;
import com.ruoyi.system.domain.grid.ext.GridPeopleExt;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridCompanyPeopleMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridCompanyPeopleService;
import com.ruoyi.system.service.grid.GridCompanyService;
import com.ruoyi.system.service.grid.GridPeopleService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridCompanyPeopleService实现
 */
@Service
@MyBaseService
public class GridCompanyPeopleServiceImpl extends BaseServiceImpl<GridCompanyPeopleMapper, GridCompanyPeople, GridCompanyPeopleExample> implements GridCompanyPeopleService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridCompanyPeopleServiceImpl.class);

    @Autowired
    GridCompanyPeopleMapper gridCompanyPeopleMapper;
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridCompanyService gridCompanyService;
    @Autowired
    private GridCompanyPeopleService gridCompanyPeopleService;

    @Override
    public List<GridCompanyPeople> selectGridCompanyPeopleByCompanyId(String companyId, String creditCode, String peopleId) {
        GridCompanyPeopleExample ex = new GridCompanyPeopleExample();
        GridCompanyPeopleExample.Criteria ca = ex.createCriteria();
        if (StringUtils.isNotBlank(companyId)) {
            ca.andCompanyIdEqualTo(companyId);
        }
        if (StringUtils.isNotBlank(creditCode)) {
            ca.andCreditCodeEqualTo(creditCode);
        }
        if (StringUtils.isNotBlank(peopleId)) {
            ca.andPeopleIdEqualTo(peopleId);
        }
        ex.setOrderByClause(" create_time desc ");
        List<GridCompanyPeople> companyPeopleList = gridCompanyPeopleService.selectByExample(ex);
        return companyPeopleList;
    }

    @Override
    public GridCompanyPeopleExt selectGridCompanyPeopleExt(Map<String, String> wgxxbMap, Map<String, String> commonMap, GridCompanyPeopleExt wsCompanyPeopleExt, Boolean companyFlag, Boolean peopleFlag) {
        if (companyFlag) {
            GridCompany wsCompany = gridCompanyService.selectByPrimaryKey(wsCompanyPeopleExt.getCompanyId());
            GridCompanyExt wsCompanyExt = BeanCopyUtil.toBean(wsCompany, GridCompanyExt.class);
            if (wsCompanyExt != null) {
                gridCompanyService.dealGridCompanyExt(wgxxbMap, commonMap, wsCompanyExt);
                wsCompanyPeopleExt.setGridCompanyExt(wsCompanyExt);
            }
        }
        if (peopleFlag) {
            GridPeople wsPeople = gridPeopleService.selectByPrimaryKey(wsCompanyPeopleExt.getPeopleId());
            GridPeopleExt wsPeopleExt = BeanCopyUtil.toBean(wsPeople, GridPeopleExt.class);
            if (wsPeopleExt != null) {
                gridPeopleService.dealPeopleExt(wgxxbMap, commonMap, wsPeopleExt);
                wsCompanyPeopleExt.setGridPeopleExt(wsPeopleExt);
            }
        }
        return wsCompanyPeopleExt;
    }

    @Override
    public int countEmployeeNum(String companyId, String creditCode) {
        GridCompanyPeopleExample ex = new GridCompanyPeopleExample();
        GridCompanyPeopleExample.Criteria ca = ex.createCriteria();
        if (StringUtils.isNotBlank(companyId)) {
            ca.andCompanyIdEqualTo(companyId);
        }
        if (StringUtils.isNotBlank(creditCode)) {
            ca.andCreditCodeEqualTo(creditCode);
        }
        return this.countByExample(ex);
    }
}
