package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridHouse;
import com.ruoyi.system.domain.grid.GridHouseExample;
import com.ruoyi.system.domain.grid.GridHousePeople;
import com.ruoyi.system.domain.grid.ext.GridHouseExt;
import com.ruoyi.system.domain.grid.vo.GridHouseSearchParam;
import com.ruoyi.system.service.BaseService;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridHouseService接口
 */
public interface GridHouseService extends BaseService<GridHouse, GridHouseExample> {

    PageInfo page(GridHouseSearchParam wsHouse, String value);

    AjaxResult add(GridHouse wsHouse);

    AjaxResult edit(GridHouse wsHouse);

    AjaxResult detail(String id);

    AjaxResult delete(String id);

    PageInfo houseToPeoplePage(String houseId);

    AjaxResult houseBindPeople(GridHousePeople wsHousePeople);

    // GridHouseExt查询字典的value值
    GridHouseExt selectGridHouseExt(GridHouseExt wsHouseExt);

    GridHouseExt dealGridHouseExt(Map<String, String> wgxxbMap, Map<String, String> commonMap, GridHouseExt wsHouseExt);

    // 住宅类型数量统计
    List<Map<String, Object>> countGridHouse(String wgCode);

    // 住宅状态数量统计
    List<Map<String, Object>> countGridHouseByFwzt(String wgCode);

    // 住宅数量总量统计
    int countAll(String wgCode);

    // 各村社区数量统计
    List<Map<String, Object>> countGridHouseByGrid();

    // 根据房屋号,业主身份证号查询
    List<GridHouse> selectGridHouseByHouseName(String houseName, String personIdCard);

    AjaxResult importExcel(MultipartFile file, String createId);

    List<GridHouse> getAllHouseList();

}
