package com.ruoyi.system.domain.task;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class TkCommonTask implements Serializable {
    private String id;

    /**
     * 乡镇id
     */
    private String baseId;

    /**
     * 任务id
     */
    private String tkId;

    /**
     * 任务状态
     */
    private Integer tkStatus;

    /**
     * 任务名称
     */
    private String tkName;

    /**
     * 发布人用户id
     */
    private String releaseUserId;

    /**
     * 发布人用户姓名
     */
    private String releaseUserName;

    /**
     * 指派人id
     */
    private String assignedUserId;

    /**
     * 指派人名字
     */
    private String assignedUserName;

    /**
     * 指派部门id
     */
    private String assignedDeptIds;

    /**
     * 指派部门名称
     */
    private String assignedDeptNames;

    /**
     * 执行人用户id
     */
    private String performUserId;

    /**
     * 执行人用户姓名
     */
    private String performUserName;

    /**
     * 执行完成期限
     */
    private Date assignedEndTime;

    /**
     * 处理完成时间
     */
    private Date assignedTime;

    /**
     * 指派说明
     */
    private String assignedNode;

    /**
     * 执行照片
     */
    private String performPicture;

    private String performNode;

    /**
     * 指派核查人id
     */
    private String zpVerificationUserId;

    /**
     * 指派核查人姓名
     */
    private String zpVerificationUserName;

    /**
     * 核查人id
     */
    private String verificationUserId;

    /**
     * 核查人姓名
     */
    private String verificationUserName;

    /**
     * 核查完成期限
     */
    private Date verificationEndTime;

    /**
     * 核查完成时间
     */
    private Date verificationTime;

    /**
     * 核查说明
     */
    private String verificationNode;

    /**
     * 核查状态 0通过 1不通过
     */
    private Integer verificationStatus;

    /**
     * 任务评分
     */
    private Integer tkScore;

    /**
     * 最终评价
     */
    private String endNode;

    /**
     * 评价时间
     */
    private Date endTime;

    /**
     * 优先级-普通0-1重要-2紧急
     */
    private Integer priorityType;

    /**
     * 所属网格
     */
    private String belongGrid;

    /**
     * 事项类型 1城乡综合网格、2企业网格、3资产网格
     */
    private Integer matterType;

    /**
     * 事项id
     */
    private String matterId;

    /**
     * 事项名字
     */
    private String matterName;

    /**
     * 延时-0正常-1延时-2同意延时-3拒绝延时
     */
    private Integer timeDelay;

    /**
     * 是否作废-0正常-1作废
     */
    private Integer isDelete;

    /**
     * 发布时间
     */
    private Date releaseTime;

    /**
     * 任务地址
     */
    private String tkAddress;

    /**
     * 处理方式-0自行处理-1上报上级-2上报中心-3指派下级
     */
    private Integer handleType;

    /**
     * 任务详情
     */
    private String tkDetail;

    /**
     * 附件
     */
    private String filePath;

    /**
     * 督办人id
     */
    private String overseeId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 修改人
     */
    private String updateBy;

    /**
     * 逻辑删除  备用字段
     */
    private String standby1;

    /**
     * 任务上报到哪一级。3三级 2二级 1一级 0中心
     */
    private String standby2;

    /**
     * 备用3  督办人
     */
    private String standby3;

    /**
     * 备用4 申请延时时间(未同意时暂时存储，同意后覆盖完成期限时间）
     */
    private String standby4;

    /**
     * 备用5 0为默认没被采集过  1  被采集过
     */
    private String standby5;

    private String roundSubtaskId;

    private String roundSubtaskCode;

    /**
     * 网格code
     */
    private String wgCode;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 评价人
     */
    private String pjPersonId;

    /**
     * 评价人姓名
     */
    private String pjPersonName;

    private Integer releaseUserRoleNum;

    private Date acceptTime;

    private Integer litigationType;

    private String complaintsPerson;

    private String complaintsPhone;

    private String objectId;

    private Integer comeFrom;

    private String wgParentId;

    private String wgParentName;

    private String parentMattetrId;

    private String parentMattetrName;

    /**
     * 关联对象id
     */
    private String gldxId;

    private String xietiao;

    /**
     * 通知状态 1执行任务未超时已通知 2执行任务超时已通知 3评价任务未超时已通知 4评价任务已超时已通知
     */
    private String tongzhiStatus;

    /**
     * 巡查事项表的id
     */
    private String roundMatterId;

    /**
     * 其他调接口地方插入（转工单时插入id）
     */
    private String formId;

    /**
     * 其他调接口地方插入 对象id
     */
    private String adviceId;

    /**
     * 其他调接口地方插入 工单编号/对象名称
     */
    private String num;

    /**
     * 其他调接口地方插入
     */
    private Date waitingtime;

    /**
     * 其他调接口地方插入
     */
    private Date plantime;

    /**
     * 其他调接口地方插入
     */
    private Date updatetime;

    /**
     * 其他调接口地方插入
     */
    private String incomingphone;

    /**
     * 其他调接口地方插入
     */
    private String formstatus;

    /**
     * 标记  0为默认没被采集过  1  被采集过
     */
    private Integer flag;

    /**
     * 签收or驳回 1签收 2驳回
     */
    private Integer qianshouorbohui;

    /**
     * 是否申请延时 0申未申请 1已申请
     */
    private Integer isdelaytime;

    /**
     * 核查图片
     */
    private String hechaPic;

    /**
     * 是否有效
     */
    private Integer isYouxiao;

    /**
     * 退回状态 0退回 1申请退回
     */
    private Integer sqBack;

    /**
     * 工单评级 1、一级 2、二级 3、三级
     */
    private Integer gsType;

    /**
     * 是否在hst库
     */
    private Integer isHst;

    /**
     * 评分
     */
    private Integer pingfen;

    /**
     * 评分备注
     */
    private String pingfenreason;

    /**
     * 微信的唯一标识
     */
    private String wxUserId;

    /**
     * 归属类型，关联吴信接口
     */
    private String guishuCode;

    private String appUserId;

    /**
     * 是否转执法 0未转 1转
     */
    private Integer isZhuanzhifa;

    /**
     * 是否转执法立案 0立案 1未立案
     */
    private Integer isZhifalian;

    /**
     * 转执法说明
     */
    private String zhifashuoming;

    private String performUserType;

    /**
     * 工单类型
     */
    private String taskType;

    /**
     * 工单签批人
     */
    private String qprIds;

    /**
     * 已签批人
     */
    private String qprId;

    /**
     * 已签批人姓名
     */
    private String qprName;

    /**
     * 签批时间
     */
    private Date qprTime;

    private static final long serialVersionUID = 1L;




    //==========逻辑字段
    /**
     * 任务状态
     */
    private String tkStatuStr;
    /**
     *处理单位
     */
    private String performUnit;
    private int color;
    private String comeFrom2;
    private String assId;
    private String assCommonTkId;
    private String wgCentreCoordinate;
    /**
     * 指派人id
     */
    private String assAssignedUserId;
    private String assAssignedUserName;
    private Date assAssignedCreatetime;
    /**
     * 指派人角色 1三级网格长-2二级网格长-3一级网格职能部门-4服务中心
     */
    private Integer assAssignedRole;
    /**
     * 被指派人id
     */
    private String assBeassignedUserId;
    /**
     * 被指派人姓名
     */
    private String assBeassignedUserName;
    /**
     * 指派人角色 1三级网格长-2二级网格长-3一级网格职能部门-4服务中心
     */
    private String assBeassignedRole;
    /**
     * 指派状态
     */
    private Integer assAssignedStatus;
    /**
     * 执行完成时间
     */
    private Date assAssignedEndTime;
    /**
     * 指派说明
     */
    private String assAssignedNode;
    /**
     * 操作记录集合
     */
    private List<TkCommonTaskDynamic> tkCommonTaskDynamics;
    private String loginUserRole;
    private int wgTaskNum;
    private int comeTaskNum;
    private String diaoduId;
    /**
     * 操作转督办数据
     */
    private List<TkCommonLeader> tkCommonLeaders;
    /**
     * 操作领导签qi数据
     */
    private List<TkCommonQianpi> tkCommonQianpi;
    /**
     * 是否催办
     */
    private boolean cuiban;
    private String loginUserGrid;
    /**
     * 状态
     */
    private String zt;
    /**
     * 关联对象名字
     */
    private String glName;
    private String dxlx;
    private String qylx;
    private String qyBaseId;
    private String qyCode;
    //12345 的数据
    private String title;
    private String cusName;
    private String contentText;
    private String planTimeString;
    private String busiNumber;
    private String cusPhone;
    private String formStatusName;
    private List<TkCommonReceive> receiveList;
    private boolean leaderZSValue;
    private boolean ZDBValue;
    private boolean CSValue;
    private String guishuName;
    private String wgName;
    private int allNum;
    private int endNum;
    private float bjl;
    private String feedback;


    //=================12345工单 前端按钮判断
    /**
     * 可签批人姓名
     */
    private String qprNames;
    /**
     * 指派部门用户id
     */
    private List<String> assignedDeptUserIds;
    /**
     * 是否能指派工单
     */
    private Boolean canAssigned = false;
    /**
     * 是否能指派部门
     */
    private Boolean canAssignedDept = false;
    /**
     * 是否能接收退回
     */
    private Boolean canAcceptBack = false;
}
