package com.ruoyi.system.domain.grid;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 网格公告
 *
 * @author wujm<wujm @ eazytec.com>
 */
@TableName("grid_wg_notice")
public class GridWgNotice extends Model<GridWgNotice> {

    private static final long serialVersionUID = 1L;

    /**
     * 通知ID
     */
    @TableId(value = "notice_id", type = IdType.AUTO)
    private Long noticeId;

    /**
     * 公告标题
     */
    private String noticeTitle;

    /**
     * 公告来源
     */
    private String noticeSource;

    /**
     * 是否置顶 1置顶 0 不置顶
     */
    private Integer noticeTop;

    /**
     * 公告内容
     */
    private String noticeContent;

    /**
     * 是否隐藏 0 隐藏 1 显示  默认隐藏
     */
    private String hiddenType;

    /**
     * 是否有效1 有效 0 无效
     */
    private Integer valid;

    /**
     * 发布人所在网格code
     */
    private String createCode;


    /**
     * 创建者
     */
    private String createBy;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @Override
    protected Serializable pkVal() {
        return this.noticeId;
    }

    public GridWgNotice() {
        super();
    }

    /**
     * setter for noticeId
     *
     * @param noticeId
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }

    /**
     * getter for noticeId
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * setter for noticeTitle
     *
     * @param noticeTitle
     */
    public void setNoticeTitle(String noticeTitle) {
        this.noticeTitle = noticeTitle;
    }

    /**
     * getter for noticeTitle
     */
    public String getNoticeTitle() {
        return noticeTitle;
    }

    /**
     * setter for noticeSource
     *
     * @param noticeSource
     */
    public void setNoticeSource(String noticeSource) {
        this.noticeSource = noticeSource;
    }

    /**
     * getter for noticeSource
     */
    public String getNoticeSource() {
        return noticeSource;
    }

    /**
     * setter for noticeTop
     *
     * @param noticeTop
     */
    public void setNoticeTop(Integer noticeTop) {
        this.noticeTop = noticeTop;
    }

    /**
     * getter for noticeTop
     */
    public Integer getNoticeTop() {
        return noticeTop;
    }

    /**
     * setter for noticeContent
     *
     * @param noticeContent
     */
    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }

    /**
     * getter for noticeContent
     */
    public String getNoticeContent() {
        return noticeContent;
    }

    /**
     * setter for hiddenType
     *
     * @param hiddenType
     */
    public void setHiddenType(String hiddenType) {
        this.hiddenType = hiddenType;
    }

    /**
     * getter for hiddenType
     */
    public String getHiddenType() {
        return hiddenType;
    }

    /**
     * setter for valid
     *
     * @param valid
     */
    public void setValid(Integer valid) {
        this.valid = valid;
    }

    /**
     * getter for valid
     */
    public Integer getValid() {
        return valid;
    }

    /**
     * setter for createCode
     *
     * @param createCode
     */
    public void setCreateCode(String createCode) {
        this.createCode = createCode;
    }

    /**
     * getter for createCode
     */
    public String getCreateCode() {
        return createCode;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
